/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.infusion.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BasicInfusionRecipe
extends AbstractInfusionRecipe {
    public BasicInfusionRecipe(ItemStack output, String oreDictInput) {
        this(output, new ItemHandle(oreDictInput));
    }

    public BasicInfusionRecipe(ItemStack output, ItemStack input) {
        this(output, new ItemHandle(input));
    }

    public BasicInfusionRecipe(ItemStack output, ItemHandle input) {
        super(output, input);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileStarlightInfuser infuser, long tick, Random rand) {
        super.onCraftClientTick(infuser, tick, rand);
        if (rand.nextInt(10) == 0) {
            Vector3 from = new Vector3(infuser).add(0.5, 0.3, 0.5);
            MiscUtils.applyRandomOffset(from, rand, 0.4f);
            EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(4 + rand.nextInt(2)), from, 1.0);
            lightbeam.setMaxAge(64);
        }
        BlockPos randPos = TileStarlightInfuser.offsetsLiquidStarlight[rand.nextInt(TileStarlightInfuser.offsetsLiquidStarlight.length)];
        Vector3 from = new Vector3(infuser).add((Vec3i)randPos);
        from.add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
        Vector3 dir = new Vector3(infuser).add(0.5, 1.6, 0.5).subtract(from);
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
        p.setColor(Color.WHITE).scale(0.2f + rand.nextFloat() * 0.1f).gravity(0.004).motion(dir.getX() / 40.0, dir.getY() / 40.0, dir.getZ() / 40.0);
    }
}

