/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.migration;

import hellfirepvp.astralsorcery.common.base.RockCrystalHandler;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class LegacyDataMigration {
    public static void migrateRockCrystalData(Consumer<String> msgOut) {
        for (WorldServer world : DimensionManager.getWorlds()) {
            RockCrystalBuffer data = (RockCrystalBuffer)WorldCacheManager.getOrLoadData((World)world, WorldCacheManager.SaveKey.ROCK_CRYSTAL);
            Map<ChunkPos, List<BlockPos>> crystalData = data.getCrystalPositions();
            int totalChunkCount = crystalData.size();
            if (totalChunkCount > 0) {
                msgOut.accept("Migrating rock crystal data for dimension " + world.field_73011_w.getDimension());
                msgOut.accept(totalChunkCount + " chunks of crystals found!");
                boolean keepingLoaded = DimensionManager.keepDimensionLoaded((int)world.field_73011_w.getDimension(), (boolean)true);
                int chunkCount = 0;
                int migrated = 0;
                int failed = 0;
                Iterator<List<BlockPos>> iterator = crystalData.values().iterator();
                while (iterator.hasNext()) {
                    List<BlockPos> positionList = iterator.next();
                    ++chunkCount;
                    int failedThisChunk = 0;
                    for (BlockPos position : positionList) {
                        if (RockCrystalHandler.INSTANCE.addOre((World)world, position, true)) {
                            ++migrated;
                            continue;
                        }
                        ++failed;
                        ++failedThisChunk;
                    }
                    if (failedThisChunk == 0) {
                        iterator.remove();
                    }
                    if (chunkCount % 200 == 0) {
                        msgOut.accept("Migrated " + chunkCount + "/" + totalChunkCount + " chunks...");
                    }
                    if (chunkCount % 100 != 0) continue;
                    world.func_72863_F().func_73240_a();
                    world.func_72863_F().func_73156_b();
                }
                if (keepingLoaded) {
                    DimensionManager.keepDimensionLoaded((int)world.field_73011_w.getDimension(), (boolean)false);
                }
                msgOut.accept("Migrated " + migrated + " entries successfully. " + failed + " entries failed to be transferred!");
            }
            data.markDirty();
        }
    }
}

