/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.block.network.IBlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.starlight.network.handlers.BlockTransmutationHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StarlightNetworkRegistry {
    private static List<IStarlightBlockHandler> dynamicBlockHandlers = new LinkedList<IStarlightBlockHandler>();

    @Nullable
    public static IStarlightBlockHandler getStarlightHandler(World world, BlockPos pos, IBlockState state, IWeakConstellation cst) {
        Block b = state.func_177230_c();
        if (b instanceof IBlockStarlightRecipient) {
            return null;
        }
        for (IStarlightBlockHandler handler : dynamicBlockHandlers) {
            if (!handler.isApplicable(world, pos, state, cst)) continue;
            return handler;
        }
        return null;
    }

    public static void registerEndpoint(IStarlightBlockHandler handler) {
        dynamicBlockHandlers.add(handler);
    }

    public static void setupRegistry() {
        StarlightNetworkRegistry.registerEndpoint(new BlockTransmutationHandler());
    }

    public static interface IStarlightBlockHandler {
        @Deprecated
        public boolean isApplicable(World var1, BlockPos var2, IBlockState var3);

        default public boolean isApplicable(World world, BlockPos pos, IBlockState state, @Nullable IWeakConstellation starlightType) {
            return this.isApplicable(world, pos, state);
        }

        public void receiveStarlight(World var1, Random var2, BlockPos var3, @Nullable IWeakConstellation var4, double var5);
    }
}

