/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.registry;

import hellfirepvp.astralsorcery.common.event.StarlightNetworkEvent;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.IndependentCrystalSource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SourceClassRegistry {
    public static final SourceClassRegistry eventInstance = new SourceClassRegistry();
    private static Map<String, SourceProvider> providerMap = new HashMap<String, SourceProvider>();

    private SourceClassRegistry() {
    }

    public void registerProvider(SourceProvider provider) {
        SourceClassRegistry.register(provider);
    }

    @Nullable
    public static SourceProvider getProvider(String identifier) {
        return providerMap.get(identifier);
    }

    public static void register(SourceProvider provider) {
        if (providerMap.containsKey(provider.getIdentifier())) {
            throw new RuntimeException("Already registered identifier SourceProvider: " + provider.getIdentifier());
        }
        providerMap.put(provider.getIdentifier(), provider);
    }

    public static void setupRegistry() {
        SourceClassRegistry.register(new IndependentCrystalSource.Provider());
        MinecraftForge.EVENT_BUS.post((Event)new StarlightNetworkEvent.SourceProviderRegistry(eventInstance));
    }

    public static interface SourceProvider {
        public IIndependentStarlightSource provideEmptySource();

        public String getIdentifier();
    }
}

