/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.tile.storage.StorageKey;
import hellfirepvp.astralsorcery.common.tile.storage.StoredItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;

public class StorageCache {
    private Map<StorageKey, List<StoredItemStack>> content = Maps.newHashMap();

    public int getTotalItemCount() {
        int i = 0;
        for (List<StoredItemStack> stacks : this.content.values()) {
            for (StoredItemStack stack : stacks) {
                i += stack.getAmount();
            }
        }
        return i;
    }

    public int getItemCount(StorageKey key) {
        int i = 0;
        for (StoredItemStack s : this.content.getOrDefault(key, Lists.newArrayList())) {
            i += s.getAmount();
        }
        return i;
    }

    public boolean add(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        StorageKey key = new StorageKey(stack);
        for (StoredItemStack s : this.content.computeIfAbsent(key, stKey -> Lists.newArrayList())) {
            if (!s.combineIntoThis(stack)) continue;
            return true;
        }
        this.content.get(key).add(new StoredItemStack(stack));
        return true;
    }

    private void mergeIntoThis(StorageCache otherStorage) {
        for (StorageKey otherKey : otherStorage.content.keySet()) {
            List thisStorage = this.content.computeIfAbsent(otherKey, stKey -> Lists.newArrayList());
            ArrayList notMerged = Lists.newArrayList();
            block1: for (StoredItemStack toMerge : otherStorage.content.get(otherKey)) {
                for (StoredItemStack thisItem : thisStorage) {
                    if (!thisItem.combineIntoThis(toMerge)) continue;
                    continue block1;
                }
                notMerged.add(toMerge);
            }
            thisStorage.addAll(notMerged);
        }
    }

    public boolean attemptTransferInto(StorageKey key, IItemHandler inv, int slot, boolean simulate) {
        if (this.content.isEmpty()) {
            return false;
        }
        List<StoredItemStack> stacks = this.content.get(key);
        if (stacks == null || stacks.isEmpty()) {
            return false;
        }
        for (StoredItemStack stack : stacks) {
            ItemStack notInserted;
            ItemStack sample = stack.getTemplateStack();
            int amountToRemove = sample.func_190916_E();
            int addedCount = amountToRemove - (notInserted = inv.insertItem(slot, sample, simulate)).func_190916_E();
            if (addedCount <= 0) continue;
            if (!simulate) {
                if (!stack.removeAmount(addedCount)) {
                    return false;
                }
                if (stack.isEmpty()) {
                    stacks.remove(stack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean attemptTransferInto(StorageKey key, IItemHandler inv, boolean simulate) {
        if (this.content.isEmpty()) {
            return false;
        }
        List<StoredItemStack> stacks = this.content.get(key);
        if (stacks == null || stacks.isEmpty()) {
            return false;
        }
        boolean change = false;
        block0: for (int i = 0; i < inv.getSlots(); ++i) {
            for (StoredItemStack stack : stacks) {
                ItemStack notInserted;
                ItemStack sample = stack.getTemplateStack();
                int amountToRemove = sample.func_190916_E();
                int addedCount = amountToRemove - (notInserted = inv.insertItem(i, sample, simulate)).func_190916_E();
                if (addedCount > 0) {
                    change = true;
                }
                if (simulate) continue;
                if (!stack.removeAmount(addedCount)) {
                    return false;
                }
                if (!stack.isEmpty()) continue;
                stacks.remove(stack);
                continue block0;
            }
        }
        return change;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList content = new NBTTagList();
        for (StorageKey key : this.content.keySet()) {
            NBTTagCompound itemStorage = new NBTTagCompound();
            itemStorage.func_74782_a("storageKey", (NBTBase)key.serialize());
            NBTTagList items = new NBTTagList();
            for (StoredItemStack stack : this.content.get(key)) {
                items.func_74742_a((NBTBase)stack.serialize());
            }
            itemStorage.func_74782_a("items", (NBTBase)items);
        }
        tag.func_74782_a("content", (NBTBase)content);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.content.clear();
        NBTTagList content = tag.func_150295_c("content", 10);
        for (int i = 0; i < content.func_74745_c(); ++i) {
            NBTTagCompound itemStorage = content.func_150305_b(i);
            StorageKey key = StorageKey.deserialize(itemStorage.func_74775_l("storageKey"));
            if (key == null) continue;
            NBTTagList items = itemStorage.func_150295_c("items", 10);
            ArrayList<StoredItemStack> stacks = new ArrayList<StoredItemStack>(items.func_74745_c());
            for (int j = 0; j < items.func_74745_c(); ++j) {
                StoredItemStack stack = StoredItemStack.deserialize(items.func_150305_b(j));
                if (stack == null) continue;
                stacks.add(stack);
            }
            this.content.put(key, stacks);
        }
    }
}

