/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.HappinessData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IRecipeManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColonyManager {
    public static IColonyManager getInstance() {
        return IMinecoloniesAPI.getInstance().getColonyManager();
    }

    public void createColony(@NotNull World var1, BlockPos var2, @NotNull EntityPlayer var3, @NotNull String var4);

    public void deleteColonyByWorld(int var1, boolean var2, World var3);

    public void deleteColonyByDimension(int var1, boolean var2, int var3);

    @Nullable
    public IColony getColonyByWorld(int var1, World var2);

    @Nullable
    public IColony getColonyByDimension(int var1, int var2);

    public IBuilding getBuilding(@NotNull World var1, @NotNull BlockPos var2);

    public IColony getColonyByPosFromWorld(@NotNull World var1, @NotNull BlockPos var2);

    public IColony getColonyByPosFromDim(int var1, @NotNull BlockPos var2);

    public boolean isTooCloseToColony(@NotNull World var1, @NotNull BlockPos var2);

    @NotNull
    public List<IColony> getColonies(@NotNull World var1);

    @NotNull
    public List<IColony> getAllColonies();

    @NotNull
    public List<IColony> getColoniesAbandonedSince(int var1);

    public IBuildingView getBuildingView(int var1, BlockPos var2);

    @Nullable
    public IColony getIColony(@NotNull World var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getClosestIColony(@NotNull World var1, @NotNull BlockPos var2);

    @Nullable
    public IColonyView getClosestColonyView(@Nullable World var1, @Nullable BlockPos var2);

    public IColony getClosestColony(@NotNull World var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull World var1, @NotNull EntityPlayer var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull World var1, UUID var2);

    public int getMinimumDistanceBetweenTownHalls();

    public void onServerTick(@NotNull TickEvent.ServerTickEvent var1);

    public void writeToNBT(@NotNull NBTTagCompound var1);

    public void readFromNBT(@NotNull NBTTagCompound var1, @NotNull World var2);

    public void onClientTick(@NotNull TickEvent.ClientTickEvent var1);

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent var1);

    public void onWorldLoad(@NotNull World var1);

    public UUID getServerUUID();

    public void setServerUUID(UUID var1);

    public void onWorldUnload(@NotNull World var1);

    public void handleColonyViewMessage(int var1, @NotNull ByteBuf var2, @NotNull World var3, boolean var4, int var5);

    public IColonyView getColonyView(int var1, int var2);

    public void handlePermissionsViewMessage(int var1, @NotNull ByteBuf var2, int var3);

    public void handleColonyViewCitizensMessage(int var1, int var2, ByteBuf var3, int var4);

    public void handleColonyViewWorkOrderMessage(int var1, ByteBuf var2, int var3);

    public void handleColonyViewRemoveCitizenMessage(int var1, int var2, int var3);

    public void handleColonyBuildingViewMessage(int var1, BlockPos var2, @NotNull ByteBuf var3, int var4);

    public void handleColonyViewRemoveBuildingMessage(int var1, BlockPos var2, int var3);

    public void handleColonyViewRemoveWorkOrderMessage(int var1, int var2, int var3);

    public void handleHappinessDataMessage(int var1, HappinessData var2, int var3);

    public boolean isSchematicDownloaded();

    public void setSchematicDownloaded(boolean var1);

    public boolean isCoordinateInAnyColony(@NotNull World var1, BlockPos var2);

    public ICompatibilityManager getCompatibilityManager();

    public IRecipeManager getRecipeManager();

    public int getTopColonyId();

    public void resetColonyViews();
}

