/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.compatibility.tinkers.ToolBrokenCheck;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Compatibility {
    private Compatibility() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean getMiningLevelCompatibility(@Nullable ItemStack stack, @Nullable String tool) {
        return !ToolBrokenCheck.checkTinkersBroken(stack);
    }

    public static boolean isSlimeBlock(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeBlock(block);
    }

    public static boolean isSlimeLeaf(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeLeaf(block);
    }

    public static boolean isSlimeSapling(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeSapling(block);
    }

    public static boolean isSlimeDirtOrGrass(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeDirtOrGrass(block);
    }

    public static int getLeafVariant(@NotNull IBlockState leaf) {
        return SlimeTreeCheck.getLeafVariant(leaf);
    }

    public static boolean isTinkersWeapon(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.isTinkersSword(stack);
    }

    public static double getAttackDamage(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.getDamage(stack);
    }

    public static int getToolLevel(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.getToolLvl(stack);
    }

    public static boolean isPamsInstalled() {
        return Loader.isModLoaded((String)"harvestcraft");
    }

    public static boolean isDynTreePresent() {
        return DynamicTreeCompat.isDynTreePresent();
    }

    public static String getDynamicTreeDamage() {
        return DynamicTreeCompat.getDynamicTreeDamage();
    }

    public static boolean isDynamicBlock(Block block) {
        return DynamicTreeCompat.isDynamicTreeBlock(block);
    }

    public static boolean isDynamicLeaf(Block block) {
        return DynamicTreeCompat.isDynamicLeavesBlock(block);
    }

    public static boolean isDynamicTrunkShell(Block block) {
        return DynamicTreeCompat.isDynamicTrunkShellBlock(block);
    }

    public static NonNullList<ItemStack> getDropsForDynamicLeaf(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune, Block leaf) {
        return DynamicTreeCompat.getDropsForLeafCompat(world, pos, blockState, fortune, leaf);
    }

    public static boolean plantDynamicSapling(World world, BlockPos location, ItemStack sapling) {
        return DynamicTreeCompat.plantDynamicSapling(world, location, sapling);
    }

    public static Runnable getDynamicTreeBreakAction(World world, BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return DynamicTreeCompat.getTreeBreakAction(world, blockToBreak, toolToUse, workerPos);
    }

    public static boolean isDynamicTreeSapling(Item item) {
        return DynamicTreeCompat.isDynamicTreeSapling(item);
    }

    public static boolean isDynamicTreeSapling(ItemStack stack) {
        return DynamicTreeCompat.isDynamicTreeSapling(stack.func_77973_b());
    }

    public static boolean isDynamicFamilyFitting(BlockPos block1, BlockPos block2, IBlockAccess world) {
        return DynamicTreeCompat.hasFittingTreeFamily(block1, block2, world);
    }
}

