/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingDeliveryman;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InteractionValidatorInitializer {
    public static void init() {
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceUser.noFuel", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof AbstractBuildingSmelterCrafter && ((AbstractBuildingSmelterCrafter)citizen.getWorkBuilding()).getCopyOfAllowedItems().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noFurnace", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof AbstractBuildingSmelterCrafter && ((AbstractBuildingSmelterCrafter)citizen.getWorkBuilding()).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.wrongFood", new Object[0]), citizen -> InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)citizen.getInventory()), ItemStackUtils.ISCOOKABLE) > 0 && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)citizen.getInventory()), ItemStackUtils.ISFOOD) == 0);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.noRestaurant", new Object[0]), citizen -> citizen.getColony() != null && citizen.getSaturation() <= 3.0 && citizen.getCitizenEntity().isPresent() && citizen.getColony().getBuildingManager().getBestRestaurant(citizen.getCitizenEntity().get()) == null && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)citizen.getInventory()), ItemStackUtils.ISFOOD) == 0);
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.workerChestFull", new Object[0]), (citizen, pos) -> {
            IItemHandler inv;
            IBuilding building;
            IColony colony;
            if (citizen.getJob() instanceof JobDeliveryman && (colony = citizen.getColony()) != null && (building = colony.getBuildingManager().getBuilding((BlockPos)pos)) != null && (inv = (IItemHandler)building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                return InventoryUtils.openSlotCount(inv) > 0L;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.noWarehouse", new Object[0]), cit -> {
            if (cit.getJob() instanceof JobDeliveryman && cit.getWorkBuilding() != null) {
                for (IWareHouse wareHouse : cit.getJob().getColony().getBuildingManager().getWareHouses()) {
                    if (!wareHouse.registerWithWareHouse((IBuildingDeliveryman)cit.getWorkBuilding())) continue;
                    return false;
                }
            }
            return true;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.farmer.noFreeFields", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingFarmer && ((BuildingFarmer)citizen.getWorkBuilding()).hasNoFields());
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("entity.farmer.noSeedSet", new Object[0]), (citizen, pos) -> {
            TileEntity tileEntity;
            World world;
            IColony colony;
            if (citizen.getJob() instanceof JobFarmer && (colony = citizen.getColony()) != null && (world = colony.getWorld()) != null && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityScarecrow) {
                return ((TileEntityScarecrow)tileEntity).getSeed() == null;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noRecipe", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingBaker && ((BuildingBaker)citizen.getWorkBuilding()).getCopyOfAllowedItems().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noFurnace", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingBaker && ((BuildingBaker)citizen.getWorkBuilding()).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.worker.inventoryFullChestFull", new Object[0]), citizen -> citizen.getWorkBuilding() != null && InventoryUtils.isProviderFull(citizen.getWorkBuilding()));
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.toolow", new Object[0]), (citizen, pos) -> {
            World world;
            IColony colony;
            IBuildingWorker workBuilding = citizen.getWorkBuilding();
            if (workBuilding != null && (colony = citizen.getColony()) != null && (world = colony.getWorld()) != null) {
                return workBuilding.getMaxToolLevel() < WorkerUtil.getCorrectHavestLevelForBlock(world.func_180495_p(pos).func_177230_c());
            }
            return false;
        });
        InteractionValidatorRegistry.registerTokenBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal", new Object[0]), (citizen, token) -> {
            IColony colony = citizen.getColony();
            if (colony != null) {
                IRequestResolver<?> resolver = citizen.getColony().getRequestManager().getRequestForToken((IToken<?>)token) == null ? null : citizen.getColony().getRequestManager().getResolverForRequest((IToken<?>)token);
                return resolver instanceof IPlayerRequestResolver || resolver instanceof IRetryingRequestResolver;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceUser.noOre", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingSmeltery && IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres().stream().anyMatch(storage -> !((List)((BuildingSmeltery)citizen.getWorkBuilding()).getCopyOfAllowedItems().getOrDefault("ores", new ArrayList())).contains(storage)));
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.fisherman.messageWaterTooFar", new Object[0]), citizen -> citizen.getJob() instanceof JobFisherman && ((JobFisherman)citizen.getJob()).getPonds().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceUser.noFuel", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof AbstractBuildingFurnaceUser && ((AbstractBuildingFurnaceUser)citizen.getWorkBuilding()).getAllowedFuel().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noFurnace", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingBaker && ((BuildingBaker)citizen.getWorkBuilding()).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.enchanter.nodrainingsset", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingEnchanter && ((BuildingEnchanter)citizen.getWorkBuilding()).getBuildingsToGatherFrom().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noplantground", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ((BuildingFlorist)citizen.getWorkBuilding()).getPlantGround().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noflowers", new Object[0]), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ItemStackUtils.isEmpty(((BuildingFlorist)citizen.getWorkBuilding()).getFlowerToGrow()) != false);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.nocompost", new Object[0]), citizen -> {
            IBuildingWorker buildingFlorist = citizen.getWorkBuilding();
            if (buildingFlorist instanceof BuildingFlorist && buildingFlorist.getColony().getWorld() != null) {
                return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)citizen.getInventory()), ItemStackUtils.IS_COMPOST) == 0 && !WorkerUtil.isThereCompostedLand((BuildingFlorist)buildingFlorist, buildingFlorist.getColony().getWorld());
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.miner.messagerequiresbetterhut", new Object[0]), citizen -> {
            AbstractBuilding buildingMiner = (AbstractBuilding)((Object)citizen.getWorkBuilding());
            if (buildingMiner instanceof BuildingMiner && citizen.getColony() != null && citizen.getColony().getWorld() != null) {
                return WorkerUtil.getLastLadder(((BuildingMiner)buildingMiner).getLadderLocation(), citizen.getColony().getWorld()) < ((BuildingMiner)buildingMiner).getDepthLimit() && ((BuildingMiner)buildingMiner).getNumberOfLevels() == 0;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.demandsHouse", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutHouse() > 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.noHouse", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutHouse() > 7 && citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutHouse() <= 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.demandsJob", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutJob() > 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.noJob", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutJob() > 7 && citizen.getCitizenHappinessHandler().getNumberOfDaysWithoutJob() <= 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.demandsTool", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getMaxOpenToolDays() > 14);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.citizen.noTool", new Object[0]), citizen -> citizen.getCitizenHappinessHandler().getMaxOpenToolDays() > 7);
    }
}

