/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.HireFireMessage;
import com.minecolonies.coremod.network.messages.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.RestartCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends AbstractWindowSkeleton
implements ButtonHandler {
    private final AbstractBuildingWorker.View building;
    private final IColonyView colony;
    private List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    private final ScrollingList citizenList;

    public WindowHireWorker(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingWorker.View)this.colony.getBuilding(buildingId);
        this.citizenList = this.findPaneOfTypeByID("unemployed", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("done", this::doneClicked);
        super.registerButton("fire", this::fireClicked);
        super.registerButton("pause", this::pauseClicked);
        super.registerButton("restart", this::restartClicked);
        super.registerButton("mode", this::modeClicked);
        this.setupSettings(this.findPaneOfTypeByID("mode", Button.class));
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.building.getHiringMode().ordinal() + 1;
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.building.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiringmode." + this.building.getHiringMode().name().toLowerCase(Locale.ENGLISH), new Object[0]));
    }

    private void restartClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane(button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        MineColonies.getNetwork().sendToServer((IMessage)new RestartCitizenMessage(this.building, id));
        this.close();
    }

    private void pauseClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane(button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        ICitizenDataView citizen = this.citizens.get(row);
        MineColonies.getNetwork().sendToServer((IMessage)new PauseCitizenMessage(this.building, id));
        citizen.setPaused(!citizen.isPaused());
    }

    private void fireClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane(button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        ICitizenDataView citizen = this.citizens.get(row);
        MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, false, id));
        this.building.removeWorkerId(id);
        citizen.setWorkBuilding(null);
        this.onOpened();
    }

    private void doneClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane(button);
        int id = this.citizens.get(row).getId();
        ICitizenDataView citizen = this.citizens.get(row);
        this.building.addWorkerId(id);
        MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, true, id));
        citizen.setWorkBuilding(this.building.getPosition());
        this.onOpened();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> !citizen.isChild()).filter(citizen -> citizen.getWorkBuilding() == null && !this.building.hasEnoughWorkers() || this.building.getPosition().equals((Object)citizen.getWorkBuilding())).sorted(Comparator.comparing(ICitizen::getName)).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        this.findPaneOfTypeByID("autoHireWarn", Label.class).off();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = (ICitizenDataView)WindowHireWorker.this.citizens.get(index);
                IBuildingWorker.Skill primary = WindowHireWorker.this.building.getPrimarySkill();
                IBuildingWorker.Skill secondary = WindowHireWorker.this.building.getSecondarySkill();
                Button isPaused = rowPane.findPaneOfTypeByID("pause", Button.class);
                if (citizen.getWorkBuilding() == null) {
                    rowPane.findPaneOfTypeByID("fire", Button.class).off();
                    rowPane.findPaneOfTypeByID("done", Button.class).on();
                    isPaused.off();
                } else {
                    rowPane.findPaneOfTypeByID("done", Button.class).off();
                    rowPane.findPaneOfTypeByID("fire", Button.class).on();
                    if (!WindowHireWorker.this.building.getColony().isManualHiring() && WindowHireWorker.this.building.getHiringMode() == HiringMode.DEFAULT || WindowHireWorker.this.building.getHiringMode() == HiringMode.AUTO) {
                        rowPane.findPaneOfTypeByID("fire", Button.class).disable();
                        WindowHireWorker.this.findPaneOfTypeByID("autoHireWarn", Label.class).on();
                    }
                    isPaused.on();
                    isPaused.setLabel(LanguageHandler.format(citizen.isPaused() ? "com.minecolonies.coremod.gui.hiring.buttonUnpaused" : "com.minecolonies.coremod.gui.hiring.buttonPaused", new Object[0]));
                }
                if (citizen.isPaused()) {
                    rowPane.findPaneOfTypeByID("restart", Button.class).on();
                } else {
                    rowPane.findPaneOfTypeByID("restart", Button.class).off();
                }
                String strength = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, IBuildingWorker.Skill.STRENGTH), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", citizen.getStrength()));
                String charisma = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, IBuildingWorker.Skill.CHARISMA), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", citizen.getCharisma()));
                String dexterity = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, IBuildingWorker.Skill.DEXTERITY), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", citizen.getDexterity()));
                String endurance = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, IBuildingWorker.Skill.ENDURANCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", citizen.getEndurance()));
                String intelligence = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, IBuildingWorker.Skill.INTELLIGENCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", citizen.getIntelligence()));
                String attributes = strength + " | " + charisma + " | " + dexterity + " | " + endurance + " | " + intelligence;
                rowPane.findPaneOfTypeByID("citizen", Label.class).setLabelText(citizen.getName());
                rowPane.findPaneOfTypeByID("attributes", Label.class).setLabelText(attributes);
            }
        });
    }

    private static String createAttributeText(String color, String text) {
        return color + text + TextFormatting.RESET.toString();
    }

    private static String createColor(IBuildingWorker.Skill primary, IBuildingWorker.Skill secondary, IBuildingWorker.Skill current) {
        if (primary == current) {
            return TextFormatting.GREEN.toString() + TextFormatting.BOLD.toString();
        }
        if (secondary == current) {
            return TextFormatting.YELLOW.toString() + TextFormatting.ITALIC.toString();
        }
        return "";
    }
}

