/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowAssignCitizen;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.AssignUnassignMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutCitizen
extends AbstractWindowBuilding<BuildingHome.View> {
    private static final String BUTTON_ASSIGN = "assign";
    private static final String BUTTON_REMOVE = "remove";
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowHutHome.xml";
    private static final String LIST_CITIZEN = "assignedCitizen";
    private final BuildingHome.View home;
    private ScrollingList citizen;

    public WindowHutCitizen(BuildingHome.View building) {
        super(building, "minecolonies:gui/windowHutHome.xml");
        super.registerButton(BUTTON_ASSIGN, this::assignClicked);
        super.registerButton(BUTTON_REMOVE, this::removeClicked);
        this.home = building;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final boolean isManualHousing = ((BuildingHome.View)this.building).getColony().isManualHousing();
        this.citizen = this.findPaneOfTypeByID(LIST_CITIZEN, ScrollingList.class);
        this.citizen.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutCitizen.this.home.getResidents().size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowHutCitizen.this.home.getColony().getCitizen(WindowHutCitizen.this.home.getResidents().get(index));
                if (citizenDataView != null) {
                    rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(citizenDataView.getName());
                    rowPane.findPaneOfTypeByID(WindowHutCitizen.BUTTON_REMOVE, Button.class).setEnabled(isManualHousing);
                }
            }
        });
        this.refreshView();
    }

    private void refreshView() {
        Button buttonAssign = this.findPaneOfTypeByID(BUTTON_ASSIGN, Button.class);
        int sparePlaces = ((BuildingHome.View)this.building).getBuildingLevel() - ((BuildingHome.View)this.building).getResidents().size();
        buttonAssign.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.home.assign", sparePlaces));
        buttonAssign.setEnabled(sparePlaces > 0 && ((BuildingHome.View)this.building).getColony().isManualHousing());
        this.citizen.refreshElementPanes();
    }

    private void assignClicked() {
        if (((BuildingHome.View)this.building).getColony().isManualHousing()) {
            if (((BuildingHome.View)this.building).getBuildingLevel() == 0) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.workerHuts.level0", new Object[0]);
                return;
            }
            if (((BuildingHome.View)this.building).getResidents().size() < ((BuildingHome.View)this.building).getBuildingLevel()) {
                WindowAssignCitizen window = new WindowAssignCitizen(((BuildingHome.View)this.building).getColony(), ((BuildingHome.View)this.building).getPosition());
                window.open();
            }
        }
    }

    private void removeClicked(@NotNull Button button) {
        if (((BuildingHome.View)this.building).getColony().isManualHousing()) {
            int row = this.citizen.getListElementIndexByPane(button);
            int citizenid = this.home.getResidents().get(row);
            this.home.removeResident(row);
            MineColonies.getNetwork().sendToServer((IMessage)new AssignUnassignMessage(this.building, false, citizenid));
            this.refreshView();
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.homeHut";
    }
}

