/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.network.messages.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.SortWarehouseMessage;
import com.minecolonies.coremod.network.messages.UpgradeWarehouseMessage;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutWareHouse
extends AbstractWindowBuilding<BuildingWareHouse.View> {
    private static final int BUILDING_LEVEL_FOR_SORTING = 3;
    private boolean allowMoreStorageUpgrades = false;

    public WindowHutWareHouse(BuildingWareHouse.View building) {
        super(building, "minecolonies:gui/windowhutwarehouse.xml");
        this.registerButton("resourceAdd", this::transferItems);
        this.registerButton("sort", this::sortWarehouse);
        if (building.isBuildingMaxLevel() && building.canUpgradeStorage()) {
            this.allowMoreStorageUpgrades = true;
        }
    }

    @Override
    public void onOpened() {
        if (((BuildingWareHouse.View)this.building).getBuildingLevel() < 3) {
            this.findPaneOfTypeByID("sort", ButtonImage.class).hide();
        }
        super.onOpened();
        this.updateResourcePane();
        MineColonies.getNetwork().sendToServer((IMessage)new MarkBuildingDirtyMessage((AbstractBuildingView)this.building));
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack(Blocks.field_150475_bE, 1), 1);
        InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), resource.getItem(), resource.getDamageValue());
        resource.setPlayerAmount(amountToSet);
        Label resourceLabel = this.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = this.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = this.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        Button addButton = this.findPaneOfTypeByID("resourceAdd", Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (!this.allowMoreStorageUpgrades) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                resourceMissingLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                neededLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                resourceMissingLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                neededLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
            }
        }
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(Integer.toString(resource.getAvailable()) + " / " + Integer.toString(resource.getAmount()));
        this.findPaneOfTypeByID("resourceQuantity", Label.class).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        this.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
    }

    private void transferItems() {
        MineColonies.getNetwork().sendToServer((IMessage)new UpgradeWarehouseMessage((AbstractBuildingView)this.building));
        this.allowMoreStorageUpgrades = false;
        this.updateResourcePane();
    }

    private void sortWarehouse() {
        MineColonies.getNetwork().sendToServer((IMessage)new SortWarehouseMessage((AbstractBuildingView)this.building));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildingWareHouse";
    }
}

