/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.views.Box;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.AddRemoveRecipeMessage;
import com.minecolonies.coremod.network.messages.ChangeRecipePriorityMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowListRecipes
extends Window
implements ButtonHandler {
    private static final String RECIPE_LIST = "recipes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowListRecipes.xml";
    private static final String OUTPUT_ICON = "output";
    private static final String RESOURCE = "resource%d";
    private static final String RES = "res%d";
    private final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
    private final AbstractBuildingWorker.View building;
    private final ScrollingList recipeList;

    public WindowListRecipes(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowListRecipes.xml");
        this.building = (AbstractBuildingWorker.View)c.getBuilding(buildingId);
        this.recipeList = this.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class);
        this.updateRecipes();
    }

    private void updateRecipes() {
        this.recipes.clear();
        this.recipes.addAll(this.building.getRecipes());
    }

    @Override
    public void onOpened() {
        this.updateRecipes();
        this.recipeList.enable();
        this.recipeList.show();
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowListRecipes.this.recipes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                String name;
                IRecipeStorage recipe = (IRecipeStorage)WindowListRecipes.this.recipes.get(index);
                ItemIcon icon = rowPane.findPaneOfTypeByID(WindowListRecipes.OUTPUT_ICON, ItemIcon.class);
                icon.setItem(recipe.getPrimaryOutput());
                if (recipe.getInput().size() <= 4) {
                    name = WindowListRecipes.RESOURCE;
                } else {
                    name = WindowListRecipes.RES;
                    rowPane.findPaneOfTypeByID("3x3", Box.class).setVisible(true);
                    rowPane.findPaneOfTypeByID("2x2", Box.class).setVisible(false);
                    icon.setPosition(80, 17);
                }
                for (int i = 0; i < recipe.getInput().size(); ++i) {
                    rowPane.findPaneOfTypeByID(String.format(name, i + 1), ItemIcon.class).setItem(recipe.getInput().get(i));
                }
            }
        });
    }

    @Override
    public void onUpdate() {
        this.updateRecipes();
        this.window.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        int row = this.recipeList.getListElementIndexByPane(button) - 1;
        if (button.getID().equals("remove")) {
            IRecipeStorage data = this.recipes.get(row + 1);
            this.building.removeRecipe(row + 1);
            MineColonies.getNetwork().sendToServer((IMessage)new AddRemoveRecipeMessage(data, this.building, true));
        } else if (button.getID().equals("up")) {
            this.building.switchIndex(row, row + 1);
            MineColonies.getNetwork().sendToServer((IMessage)new ChangeRecipePriorityMessage(this.building, row, true));
        } else if (button.getID().equals("down")) {
            this.building.switchIndex(row, row - 1);
            MineColonies.getNetwork().sendToServer((IMessage)new ChangeRecipePriorityMessage(this.building, row, false));
        } else if (button.getID().equals("cancel")) {
            this.building.openGui(false);
        }
    }
}

