/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.ICitizenAssignable;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCitizenAssignable
extends AbstractSchematicProvider
implements ICitizenAssignable {
    @NotNull
    protected final IColony colony;
    private final List<ICitizenData> assignedCitizen = Lists.newArrayList();

    public AbstractCitizenAssignable(BlockPos pos, IColony colony) {
        super(pos);
        this.colony = colony;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.assignedCitizen.clear();
    }

    @Override
    @NotNull
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void onDestroyed() {
        this.assignedCitizen.clear();
    }

    @Override
    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    @Override
    public void onColonyTick(IColony colony) {
    }

    @Override
    public ICitizenData getMainCitizen() {
        if (this.assignedCitizen.isEmpty()) {
            return null;
        }
        return this.assignedCitizen.get(0);
    }

    @Override
    public List<ICitizenData> getAssignedCitizen() {
        return new ArrayList<ICitizenData>(this.assignedCitizen);
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            this.assignedCitizen.remove(citizen);
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.markDirty();
        }
    }

    @Override
    public boolean isCitizenAssigned(ICitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    @Override
    public Optional<AbstractEntityCitizen> getMainCitizenEntity() {
        if (this.assignedCitizen.isEmpty()) {
            return Optional.empty();
        }
        return this.assignedCitizen.get(0).getCitizenEntity();
    }

    @Override
    public final boolean hasAssignedCitizen() {
        return !this.assignedCitizen.isEmpty();
    }

    @Override
    @Nullable
    public List<Optional<AbstractEntityCitizen>> getAssignedEntities() {
        return this.assignedCitizen.stream().filter(Objects::nonNull).map(ICitizenData::getCitizenEntity).collect(Collectors.toList());
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (this.assignedCitizen.contains(citizen) || this.isFull()) {
            return false;
        }
        if (citizen != null) {
            this.assignedCitizen.add(citizen);
        }
        this.colony.getCitizenManager().calculateMaxCitizens();
        this.markDirty();
        return true;
    }

    @Override
    public boolean hasAssignedCitizen(ICitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    @Override
    public boolean isFull() {
        return this.assignedCitizen.size() >= this.getMaxInhabitants();
    }

    @Override
    public int getMaxInhabitants() {
        return 1;
    }
}

