/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutFlorist;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobFlorist;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFlorist
extends AbstractFilterableListBuilding {
    private static final String FLORIST = "Florist";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_PLANTGROUND = "plantGround";
    private static final String FLOWER_NAME = "flower";
    private static final int BASIC_FLOWER_META = 0;
    private final List<BlockPos> plantGround = new ArrayList<BlockPos>();

    public BuildingFlorist(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b() == ModItems.compost, new Tuple((Object)64, (Object)true));
    }

    public List<BlockPos> getPlantGround() {
        return ImmutableList.copyOf(this.plantGround);
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobFlorist(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return FLORIST;
    }

    @Override
    public String getSchematicName() {
        return FLORIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockCompostedDirt && !this.plantGround.contains(pos)) {
            this.plantGround.add(pos);
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        NBTTagList compostBinTagList = compound.func_150295_c(TAG_PLANTGROUND, 10);
        for (int i = 0; i < compostBinTagList.func_74745_c(); ++i) {
            this.plantGround.add(NBTUtil.func_186861_c((NBTTagCompound)compostBinTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList compostBinTagList = new NBTTagList();
        for (BlockPos entry : this.plantGround) {
            NBTTagCompound compostBinCompound = new NBTTagCompound();
            compostBinCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            compostBinTagList.func_74742_a((NBTBase)compostBinCompound);
        }
        compound.func_74782_a(TAG_PLANTGROUND, (NBTBase)compostBinTagList);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.florist;
    }

    public void removePlantableGround(BlockPos pos) {
        this.plantGround.remove(pos);
    }

    @Nullable
    public ItemStack getFlowerToGrow() {
        List stacks = BuildingFlorist.getPlantablesForBuildingLevel(this.getBuildingLevel()).stream().filter(stack -> !this.isAllowedItem("flowers", (ItemStorage)stack)).collect(Collectors.toList());
        if (stacks.isEmpty()) {
            return null;
        }
        Collections.shuffle(stacks);
        return ((ItemStorage)stacks.get(0)).getItemStack();
    }

    public static List<ItemStorage> getPlantablesForBuildingLevel(int level) {
        switch (level) {
            case 0: 
            case 1: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(storage -> storage.getDamageValue() == 0).filter(itemStorage -> itemStorage.getItem().getRegistryName().func_110623_a().contains(FLOWER_NAME)).collect(Collectors.toList());
            }
            case 2: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(itemStorage -> itemStorage.getItem().getRegistryName().func_110623_a().contains(FLOWER_NAME)).collect(Collectors.toList());
            }
        }
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables();
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFlorist(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

