/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutLumberjack;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractFilterableListBuilding {
    private static final String TAG_REPLANT = "shouldReplant";
    private static final String TAG_RESTRICT_START = "startRestrictionPosition";
    private static final String TAG_RESTRICT_END = "endRestrictionPosition";
    private static final String TAG_RESTRICT = "restrict";
    private boolean replant = true;
    private boolean restrict = false;
    private BlockPos startRestriction = null;
    private BlockPos endRestriction = null;
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "Lumberjack";

    public BuildingLumberjack(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        if (this.getMainCitizen() != null && this.getMainCitizen().getInventory() != null) {
            int invSIze = this.getMainCitizen().getInventory().func_70302_i_();
            int keptStacks = 0;
            for (int i = 0; i < invSIze; ++i) {
                ItemStack stack = this.getMainCitizen().getInventory().func_70301_a(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue() || !ItemStackUtils.isStackSapling(stack)) continue;
                boolean isAlreadyInList = false;
                for (Map.Entry entry : toKeep.entrySet()) {
                    if (!((Predicate)entry.getKey()).test(stack)) continue;
                    isAlreadyInList = true;
                }
                if (isAlreadyInList) continue;
                toKeep.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
                if (++keptStacks < this.getMaxBuildingLevel() * 2) continue;
                return toKeep;
            }
        }
        return toKeep;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.lumberjack;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.replant = compound.func_74764_b(TAG_REPLANT) ? compound.func_74767_n(TAG_REPLANT) : true;
        if (compound.func_74764_b(TAG_RESTRICT)) {
            this.restrict = compound.func_74767_n(TAG_RESTRICT);
        }
        this.startRestriction = compound.func_74764_b(TAG_RESTRICT_START) ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(TAG_RESTRICT_START)) : null;
        this.endRestriction = compound.func_74764_b(TAG_RESTRICT_END) ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(TAG_RESTRICT_END)) : null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74757_a(TAG_REPLANT, this.replant);
        if (this.startRestriction != null) {
            compound.func_74782_a(TAG_RESTRICT_START, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.startRestriction));
        }
        if (this.endRestriction != null) {
            compound.func_74782_a(TAG_RESTRICT_END, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.endRestriction));
        }
        compound.func_74757_a(TAG_RESTRICT, this.restrict);
        return compound;
    }

    @Override
    @NotNull
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.replant);
        buf.writeBoolean(this.restrict);
    }

    public boolean shouldReplant() {
        return this.replant;
    }

    public void setShouldReplant(boolean shouldReplant) {
        this.replant = shouldReplant;
        this.markDirty();
    }

    public boolean shouldRestrict() {
        if (this.restrict && (this.startRestriction == null || this.endRestriction == null)) {
            this.restrict = false;
            this.markDirty();
        }
        return this.restrict;
    }

    public void setShouldRestrict(boolean shouldRestrict) {
        this.restrict = shouldRestrict;
        this.markDirty();
    }

    public void setRestrictedArea(BlockPos startPosition, BlockPos endPosition) {
        this.startRestriction = startPosition;
        this.endRestriction = endPosition;
    }

    public BlockPos getStartRestriction() {
        return this.startRestriction;
    }

    public BlockPos getEndRestriction() {
        return this.endRestriction;
    }

    public static class View
    extends AbstractFilterableListsView {
        public boolean shouldReplant = true;
        public boolean shouldRestrict = false;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.shouldReplant = buf.readBoolean();
            this.shouldRestrict = buf.readBoolean();
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutLumberjack(this);
        }
    }
}

