/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.sounds.ArcherSounds;
import com.minecolonies.api.sounds.KnightSounds;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobGuard
extends AbstractJob {
    public AbstractJobGuard(ICitizenData entity) {
        super(entity);
    }

    protected abstract AbstractEntityAIGuard generateGuardAI();

    @Override
    public AbstractAISkeleton<? extends IJob> generateAI() {
        return this.generateGuardAI();
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
        if (source.func_76346_g() instanceof EntityEnderman && citizen.getCitizenColonyHandler().getColony() != null) {
            citizen.getCitizenColonyHandler().getColony().getStatsManager().triggerAchievement(ModAchievements.achievementGuardDeathEnderman);
        }
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? ArcherSounds.Female.badWeather : KnightSounds.Male.badWeather;
        }
        return null;
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? ArcherSounds.Female.offToBed : KnightSounds.Male.offToBed;
        }
        return null;
    }

    @Override
    public boolean allowsAvoidance() {
        return false;
    }

    public boolean isAsleep() {
        return this.getWorkerAI() != null && this.getWorkerAI().getState() == AIWorkerState.GUARD_SLEEP;
    }
}

