/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.babarianEvent.BarbarianHorde;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.babarianEvent.BarbarianRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateEventUtils;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class RaidManager
implements IRaiderManager {
    public static final double SPAWN_MODIFIER = 1.5;
    private boolean raidTonight = false;
    private boolean raidBeenCalculated = false;
    private boolean haveBarbEvents = true;
    private int nightsSinceLastRaid = 0;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Colony colony;
    private boolean spiesEnabled;
    private BlockPos lastBuilding;
    private int buildingPosUsage = 0;

    public RaidManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveRaiderEvents() {
        return this.haveBarbEvents;
    }

    @Override
    public boolean hasRaidBeenCalculated() {
        return this.raidBeenCalculated;
    }

    @Override
    public boolean willRaidTonight() {
        return this.raidTonight;
    }

    @Override
    public void setCanHaveRaiderEvents(boolean canHave) {
        this.haveBarbEvents = canHave;
    }

    @Override
    public void addRaiderSpawnPoint(BlockPos pos) {
        this.lastSpawnPoints.add(pos);
    }

    @Override
    public void setHasRaidBeenCalculated(boolean hasSet) {
        this.raidBeenCalculated = hasSet;
    }

    @Override
    public void setWillRaidTonight(boolean willRaid) {
        this.raidTonight = willRaid;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public void setSpiesEnabled(boolean enabled) {
        if (this.spiesEnabled != enabled) {
            this.colony.markDirty();
        }
        this.spiesEnabled = enabled;
    }

    @Override
    public void raiderEvent() {
        if (this.colony.getWorld() == null || !this.canRaid()) {
            return;
        }
        int amount = this.calcBarbarianAmount();
        if (amount <= 0) {
            return;
        }
        int raidCount = Math.max(1, amount / 20);
        HashSet<BlockPos> spawnPoints = new HashSet<BlockPos>();
        for (int i = 0; i < raidCount; ++i) {
            BlockPos targetSpawnPoint = this.calculateSpawnLocation();
            if (targetSpawnPoint.equals((Object)this.colony.getCenter()) || targetSpawnPoint.func_177956_o() > Configurations.gameplay.maxYForBarbarians) {
                return;
            }
            spawnPoints.add(targetSpawnPoint);
        }
        amount = (int)Math.ceil((float)amount / (float)spawnPoints.size());
        for (BlockPos targetSpawnPoint : spawnPoints) {
            IColonyRaidEvent event;
            if (Configurations.gameplay.enableInDevelopmentFeatures) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "Horde Spawn Point: " + targetSpawnPoint, new Object[0]);
            }
            if (PirateEventUtils.canSpawnPirateEventAt(this.colony, targetSpawnPoint, amount)) {
                event = new PirateRaidEvent(this.colony);
                ((PirateRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((PirateRaidEvent)event).setShipSize(ShipSize.getShipForRaidLevel(amount));
                this.colony.getEventManager().addEvent(event);
            } else {
                event = new BarbarianRaidEvent(this.colony);
                ((BarbarianRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((BarbarianRaidEvent)event).setHorde(new BarbarianHorde(amount));
                this.colony.getEventManager().addEvent(event);
            }
            this.addRaiderSpawnPoint(targetSpawnPoint);
        }
        this.colony.markDirty();
    }

    @Override
    public BlockPos calculateSpawnLocation() {
        Random random = this.colony.getWorld().field_73012_v;
        BlockPos pos = this.colony.getRaiderManager().getRandomOutsiderInDirection(random.nextInt(2) < 1 ? EnumFacing.EAST : EnumFacing.WEST, random.nextInt(2) < 1 ? EnumFacing.NORTH : EnumFacing.SOUTH);
        if (pos.equals((Object)this.colony.getCenter())) {
            Log.getLogger().info("Spawning at colony center: " + this.colony.getCenter().func_177958_n() + " " + this.colony.getCenter().func_177952_p());
            return this.colony.getCenter();
        }
        return BlockPosUtil.findLand(pos, this.colony.getWorld());
    }

    @Override
    public BlockPos getRandomOutsiderInDirection(EnumFacing directionX, EnumFacing directionZ) {
        int radius;
        BlockPos center = this.colony.getCenter();
        World world = this.colony.getWorld();
        if (world == null) {
            return center;
        }
        List positions = this.colony.getWayPoints().keySet().stream().filter(pos -> RaidManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList());
        positions.addAll(this.colony.getBuildingManager().getBuildings().keySet().stream().filter(pos -> RaidManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList()));
        BlockPos thePos = center;
        double distance = 0.0;
        ISchematicProvider theBuilding = null;
        for (BlockPos pos2 : positions) {
            double currentDistance = center.func_177951_i((Vec3i)pos2);
            if (!(currentDistance > distance) || !world.func_175697_a(pos2, 10)) continue;
            distance = currentDistance;
            thePos = pos2;
            theBuilding = this.colony.getBuildingManager().getBuilding(thePos);
        }
        int minDistance = 0;
        if (theBuilding != null) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = theBuilding.getCorners();
            minDistance = Math.max((Integer)((Tuple)corners.func_76341_a()).func_76341_a() - (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a() - (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        }
        for (radius = 10; radius < 75 && world.func_175697_a(thePos, radius); radius += 10) {
        }
        int dist = Math.max(minDistance, Math.min(radius, 75));
        thePos = thePos.func_177967_a(directionX, dist);
        thePos = thePos.func_177967_a(directionZ, dist);
        int randomDegree = world.field_73012_v.nextInt(360);
        double rads = (double)randomDegree / 180.0 * Math.PI;
        double x = Math.round((double)thePos.func_177958_n() + 3.0 * Math.sin(rads));
        double z = Math.round((double)thePos.func_177952_p() + 3.0 * Math.cos(rads));
        return new BlockPos(x, (double)thePos.func_177956_o(), z);
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public int calcBarbarianAmount() {
        return Math.min(Configurations.gameplay.maxBarbarianSize, (int)((double)this.getColonyRaidLevel() / 1.5 * ((double)Configurations.gameplay.spawnBarbarianSize * 0.1)));
    }

    private static boolean isInDirection(EnumFacing directionX, EnumFacing directionZ, BlockPos vector) {
        return EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)0.0f) == directionX && EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)vector.func_177952_p()) == directionZ;
    }

    @Override
    public boolean isRaided() {
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            if (!(event instanceof IColonyRaidEvent) || event.getStatus() != EventStatus.PROGRESSING) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNightFall() {
        this.nightsSinceLastRaid = !this.isRaided() ? ++this.nightsSinceLastRaid : 0;
    }

    @Override
    public int getNightsSinceLastRaid() {
        return this.nightsSinceLastRaid;
    }

    @Override
    public void setNightsSinceLastRaid(int nightsSinceLastRaid) {
        this.nightsSinceLastRaid = nightsSinceLastRaid;
    }

    @Override
    public void tryToRaidColony(IColony colony) {
        if (this.canRaid() && this.isItTimeToRaid()) {
            this.raiderEvent();
        }
    }

    @Override
    public boolean canRaid() {
        return this.colony.getWorld().func_175659_aa() != EnumDifficulty.PEACEFUL && Configurations.gameplay.doBarbariansSpawn && this.colony.getRaiderManager().canHaveRaiderEvents() && !this.colony.getPackageManager().getImportantColonyPlayers().isEmpty();
    }

    @Override
    public boolean isItTimeToRaid() {
        if (this.colony.getCitizenManager().getCitizens().size() < 5) {
            return false;
        }
        if (this.colony.getWorld().func_72935_r() && !this.colony.getRaiderManager().hasRaidBeenCalculated()) {
            this.colony.getRaiderManager().setHasRaidBeenCalculated(true);
            if (!this.colony.getRaiderManager().willRaidTonight()) {
                boolean raid = RaidManager.raidThisNight(this.colony.getWorld(), this.colony);
                if (Configurations.gameplay.enableInDevelopmentFeatures) {
                    LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "Will raid tonight: " + raid, new Object[0]);
                }
                this.colony.getRaiderManager().setWillRaidTonight(raid);
            }
            return false;
        }
        if (this.colony.getRaiderManager().willRaidTonight() && !this.colony.getWorld().func_72935_r() && this.colony.getRaiderManager().hasRaidBeenCalculated()) {
            this.colony.getRaiderManager().setHasRaidBeenCalculated(false);
            this.colony.getRaiderManager().setWillRaidTonight(false);
            if (Configurations.gameplay.enableInDevelopmentFeatures) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "Night reached: raiding", new Object[0]);
            }
            return true;
        }
        if (!this.colony.getWorld().func_72935_r() && this.colony.getRaiderManager().hasRaidBeenCalculated()) {
            this.colony.getRaiderManager().setHasRaidBeenCalculated(false);
        }
        return false;
    }

    @Override
    public int getColonyRaidLevel() {
        int levels = 0;
        ArrayList<ICitizenData> citizensList = new ArrayList<ICitizenData>(this.colony.getCitizenManager().getCitizens());
        for (ICitizenData citizen : citizensList) {
            levels += citizen.getLevel() / 5;
        }
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            levels += building.getBuildingLevel();
        }
        return levels += citizensList.size();
    }

    private static boolean raidThisNight(World world, IColony colony) {
        return colony.getRaiderManager().getNightsSinceLastRaid() > Configurations.gameplay.minimumNumberOfNightsBetweenRaids && world.field_73012_v.nextDouble() < 1.0 / (double)Configurations.gameplay.averageNumberOfNightsBetweenRaids;
    }

    @Override
    @NotNull
    public BlockPos getRandomBuilding() {
        ++this.buildingPosUsage;
        if (this.buildingPosUsage > 3 || this.lastBuilding == null) {
            this.buildingPosUsage = 0;
            Collection<IBuilding> buildingList = this.colony.getBuildingManager().getBuildings().values();
            Object[] buildingArray = buildingList.toArray();
            if (buildingArray.length != 0) {
                int rand = this.colony.getWorld().field_73012_v.nextInt(buildingArray.length);
                IBuilding building = (IBuilding)buildingArray[rand];
                this.lastBuilding = building.getPosition();
            } else {
                this.lastBuilding = this.colony.getCenter();
            }
        }
        return this.lastBuilding;
    }
}

