/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRequest<R extends IRequestable>
implements IRequest<R> {
    @NotNull
    private final IToken token;
    @NotNull
    private final R requested;
    @NotNull
    private final List<IToken> children;
    @NotNull
    private final IRequester requester;
    @NotNull
    private RequestState state = RequestState.CREATED;
    @Nullable
    private R result;
    @Nullable
    private IToken parent;
    private List<ItemStack> deliveries = Lists.newArrayList();
    private ImmutableList<ItemStack> itemExamples;

    protected AbstractRequest(@NotNull IRequester requester, @NotNull IToken token, @NotNull R requested) {
        this.requester = requester;
        this.token = token;
        this.requested = requested;
        this.children = new ArrayList<IToken>();
    }

    protected AbstractRequest(@NotNull IRequester requester, @NotNull IToken token, @NotNull RequestState state, @NotNull R requested) {
        this.requester = requester;
        this.token = token;
        this.state = state;
        this.requested = requested;
        this.children = new ArrayList<IToken>();
    }

    @Override
    @NotNull
    public TypeToken<? extends R> getType() {
        return TypeToken.of(this.getRequest().getClass());
    }

    @Override
    @NotNull
    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    public <T extends IToken> T getId() {
        return (T)this.token;
    }

    @Override
    @NotNull
    public RequestState getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull IRequestManager manager, @NotNull RequestState state) {
        this.state = state;
        manager.getLogger().debug("Updated state from: " + this.getId() + " to: " + (Object)((Object)state));
        if (this.hasParent() && this.getParent() != null) {
            try {
                manager.getRequestForToken((IToken<?>)this.getParent()).childStateUpdated(manager, (IToken)this.getId());
            }
            catch (IllegalArgumentException ex) {
                Log.getLogger().error((Object)new IllegalStateException("Failed to update parent state.", ex));
            }
        }
    }

    @Override
    @NotNull
    public R getRequest() {
        return this.requested;
    }

    @Override
    @Nullable
    public R getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NotNull R result) {
        this.result = result;
    }

    @Override
    public boolean hasResult() {
        return this.getResult() != null;
    }

    @Override
    @Nullable
    public <T extends IToken> T getParent() {
        return (T)this.parent;
    }

    @Override
    public <T extends IToken> void setParent(@Nullable T parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public <T extends IToken> void addChild(@NotNull T child) {
        this.children.add(child);
    }

    @Override
    public <T extends IToken> void addChildren(T ... children) {
        for (T theToken : children) {
            this.addChild(theToken);
        }
    }

    @Override
    public <T extends IToken> void addChildren(@NotNull Collection<T> children) {
        for (IToken theToken : children) {
            this.addChild(theToken);
        }
    }

    @Override
    public <T extends IToken> void removeChild(@NotNull T child) {
        this.children.remove(child);
    }

    @Override
    public <T extends IToken> void removeChildren(T ... children) {
        for (T theToken : children) {
            if (!this.children.contains(theToken)) continue;
            this.removeChild(theToken);
        }
    }

    @Override
    public <T extends IToken> void removeChildren(@NotNull Collection<T> children) {
        for (IToken theToken : children) {
            if (!this.children.contains(theToken)) continue;
            this.removeChild(theToken);
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    @NotNull
    public ImmutableCollection<IToken> getChildren() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.children);
        return builder.build();
    }

    @Override
    public void childStateUpdated(@NotNull IRequestManager manager, @NotNull IToken child) {
        if (!this.children.contains(child)) {
            Log.getLogger().warn("The given child:" + child + " could not update the parent:" + this.getId() + " as it was not registered.");
        }
        try {
            IRequest<?> childRequest = manager.getRequestForToken(child);
            if (childRequest.getState() == RequestState.IN_PROGRESS && this.getState().ordinal() < RequestState.IN_PROGRESS.ordinal()) {
                this.setState(manager, RequestState.IN_PROGRESS);
                manager.getLogger().debug("First child entering progression: " + child + " setting progression state for: " + this.getId());
            }
        }
        catch (IllegalArgumentException ex) {
            Log.getLogger().error((Object)new IllegalStateException("Failed to update request data when child changed.", ex));
        }
    }

    @Override
    public boolean canBeDelivered() {
        return !this.getDeliveries().isEmpty();
    }

    @Override
    @NotNull
    public ImmutableList<ItemStack> getDeliveries() {
        return ImmutableList.copyOf(this.deliveries);
    }

    @Override
    public void overrideCurrentDeliveries(@NotNull ImmutableList<ItemStack> stacks) {
        this.deliveries = Lists.newArrayList(stacks);
    }

    @Override
    public void addDelivery(@NotNull ItemStack stack) {
        this.deliveries.add(stack);
        this.deliveries = InventoryUtils.processItemStackListAndMerge(this.deliveries);
    }

    @Override
    @NotNull
    public ITextComponent getLongDisplayString() {
        return this.getShortDisplayString();
    }

    @Override
    @NotNull
    public ResourceLocation getDisplayIcon() {
        return new ResourceLocation("missingno");
    }

    @Override
    public List<ItemStack> getDisplayStacks() {
        if (!(this.getRequest() instanceof IDeliverable)) {
            return Lists.newArrayList();
        }
        IDeliverable deliverable = (IDeliverable)this.getRequest();
        if (this.itemExamples == null) {
            this.itemExamples = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
                NonNullList stacks = NonNullList.func_191196_a();
                try {
                    item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName());
                }
                return stacks.stream().filter(deliverable::matches);
            }).collect(Collectors.toList()));
        }
        return this.itemExamples;
    }

    @Override
    @NotNull
    public <T> Optional<T> getRequestOfType(Class<T> tClass) {
        R request = this.getRequest();
        if (tClass.isInstance(request)) {
            return Optional.of(tClass.cast(request));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRequest)) {
            return false;
        }
        AbstractRequest that = (AbstractRequest)o;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        if (!this.requested.equals(that.requested)) {
            return false;
        }
        if (!this.getChildren().equals(that.getChildren())) {
            return false;
        }
        if (!this.getRequester().equals(that.getRequester())) {
            return false;
        }
        if (this.getState() != that.getState()) {
            return false;
        }
        if (this.getResult() != null ? !this.getResult().equals(that.getResult()) : that.getResult() != null) {
            return false;
        }
        if (this.getParent() != null ? !this.getParent().equals(that.getParent()) : that.getParent() != null) {
            return false;
        }
        if (!this.getDeliveries().equals(that.getDeliveries())) {
            return false;
        }
        return Objects.equals(this.itemExamples, that.itemExamples);
    }

    public int hashCode() {
        int result1 = this.getId().hashCode();
        result1 = 31 * result1 + this.requested.hashCode();
        result1 = 31 * result1 + this.getChildren().hashCode();
        result1 = 31 * result1 + this.getRequester().hashCode();
        result1 = 31 * result1 + this.getState().hashCode();
        result1 = 31 * result1 + (this.getResult() != null ? this.getResult().hashCode() : 0);
        result1 = 31 * result1 + (this.getParent() != null ? this.getParent().hashCode() : 0);
        result1 = 31 * result1 + this.getDeliveries().hashCode();
        result1 = 31 * result1 + (this.itemExamples != null ? this.itemExamples.hashCode() : 0);
        return result1;
    }
}

