/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.util.ChunkDataHelper;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ClaimChunksCommand
implements IActionCommand {
    public static final String DESC = "claim";

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        if (sender instanceof EntityPlayerMP && AbstractSingleCommand.isPlayerOpped(sender)) {
            int colonyId = actionMenuState.getIntegerForArgument("colony");
            int dimId = actionMenuState.getIntegerForArgument("dimension");
            int range = actionMenuState.getIntValueForArgument("range", Configurations.gameplay.workingRangeTownHallChunks);
            Boolean add = actionMenuState.getBooleanForArgument("add");
            World senderWorld = sender.func_130014_f_();
            BlockPos senderPos = sender.func_180425_c();
            if (range > Configurations.gameplay.workingRangeTownHallChunks * 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You are trying to claim an area bigger than twice the colony size! Aborting to avoid lags and crashes."));
                return;
            }
            IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)senderWorld.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
            if (chunkManager == null) {
                Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
                return;
            }
            if (chunkManager.getAllChunkStorages().size() > 50000) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You already got a lot of chunks to be claimed in the storage, please try to generate these chunks bevore increasing it."));
                return;
            }
            ChunkDataHelper.claimChunksInRange(colonyId, dimId, add == null || add != false, senderPos, range, 0, senderWorld);
            sender.func_145747_a((ITextComponent)new TextComponentString("Succesfully claimed chunks in every direction"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("You do not have permission to claim land like that!"));
        }
    }
}

