/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.enchanter;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.JobEnchanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.network.messages.CircleParticleEffectMessage;
import com.minecolonies.coremod.network.messages.StreamParticleEffectMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkEnchanter
extends AbstractEntityAIInteract<JobEnchanter> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int CHARISMA_MULTIPLIER = 1;
    private static final Predicate<ItemStack> IS_ANCIENT_TOME = item -> !item.func_190926_b() && item.func_77973_b() == ModItems.ancientTome;
    private static final long MIN_DISTANCE_TO_DRAIN = 5L;
    private static final int MAX_PROGRESS_TICKS = 20;
    private static final int MAX_ENCHANTMENT_TICKS = 300;
    private ICitizenData citizenToGatherFrom = null;
    private int progressTicks = 0;

    public EntityAIWorkEnchanter(@NotNull JobEnchanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 20), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.ENCHANTER_DRAIN, this::gatherAndDrain, 10), new AITarget((IAIState)AIWorkerState.ENCHANT, this::enchant, 20));
        this.worker.getCitizenExperienceHandler().setSkillModifier(1 * this.worker.getCitizenData().getCharisma() + 2 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        if (this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        if (this.worker.getCitizenExperienceHandler().getLevel() < ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel()) {
            BuildingEnchanter enchanterBuilding = this.getOwnBuilding(BuildingEnchanter.class);
            if (enchanterBuilding.getBuildingsToGatherFrom().isEmpty()) {
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.enchanter.nodrainingsset", new Object[0]), ChatPriority.BLOCKING));
                }
                return AIWorkerState.IDLE;
            }
            BlockPos posToDrainFrom = enchanterBuilding.getRandomBuildingToDrainFrom();
            if (posToDrainFrom == null) {
                return AIWorkerState.IDLE;
            }
            ((JobEnchanter)this.job).setBuildingToDrainFrom(posToDrainFrom);
            return AIWorkerState.ENCHANTER_DRAIN;
        }
        int ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), IS_ANCIENT_TOME);
        if (ancientTomesInInv <= 0) {
            int amountOfAncientTomes = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), IS_ANCIENT_TOME);
            if (amountOfAncientTomes > 0) {
                this.needsCurrently = IS_ANCIENT_TOME;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack(ModItems.ancientTome, 1));
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.ENCHANT;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState enchant() {
        ICitizenData data;
        int ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), IS_ANCIENT_TOME);
        if (ancientTomesInInv < 1) {
            return AIWorkerState.DECIDE;
        }
        if (this.progressTicks++ < 300 / ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel()) {
            MineColonies.getNetwork().sendToAllTracking((IMessage)new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 2.0, 0.0), EnumParticleTypes.ENCHANTMENT_TABLE, this.progressTicks), (Entity)this.worker);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.5, 0.0), EnumParticleTypes.ENCHANTMENT_TABLE, this.progressTicks), (Entity)this.worker);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.0, 0.0), EnumParticleTypes.ENCHANTMENT_TABLE, this.progressTicks), (Entity)this.worker);
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
            } else {
                this.worker.func_184609_a(EnumHand.OFF_HAND);
            }
            return this.getState();
        }
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), IS_ANCIENT_TOME);
        if (slot != -1 && (data = this.worker.getCitizenData()) != null) {
            int openSlot = InventoryUtils.getFirstOpenSlotFromItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            if (openSlot == -1) {
                this.incrementActionsDone();
                this.progressTicks = 0;
                return AIWorkerState.IDLE;
            }
            Tuple<ItemStack, Integer> tuple = IColonyManager.getInstance().getCompatibilityManager().getRandomEnchantmentBook(((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel());
            data.spendLevels((Integer)tuple.func_76340_b());
            this.worker.getCitizenExperienceHandler().updateLevel();
            this.worker.getInventoryCitizen().func_70299_a(openSlot, (ItemStack)tuple.func_76341_a());
            InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)this.worker.getInventoryCitizen()), new ItemStack(ModItems.ancientTome));
            this.incrementActionsDoneAndDecSaturation();
        }
        this.progressTicks = 0;
        return AIWorkerState.IDLE;
    }

    private IAIState gatherAndDrain() {
        if (((JobEnchanter)this.job).getPosToDrainFrom() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(((JobEnchanter)this.job).getPosToDrainFrom())) {
            return this.getState();
        }
        AbstractBuildingWorker buildingWorker = ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getBuildingManager().getBuilding(((JobEnchanter)this.job).getPosToDrainFrom(), AbstractBuildingWorker.class);
        if (buildingWorker == null) {
            this.resetDraining();
            this.getOwnBuilding(BuildingEnchanter.class).removeWorker(((JobEnchanter)this.job).getPosToDrainFrom());
            return AIWorkerState.IDLE;
        }
        if (this.citizenToGatherFrom == null) {
            Optional citizen;
            List workers = buildingWorker.getAssignedEntities().stream().filter(e -> e.isPresent() && ((AbstractEntityCitizen)((Object)((Object)e.get()))).getCitizenData().getLevel() > 0).collect(Collectors.toList());
            if (workers.size() > 1) {
                citizen = (Optional)workers.get(this.worker.getRandom().nextInt(workers.size()));
            } else {
                if (workers.isEmpty()) {
                    this.resetDraining();
                    return AIWorkerState.DECIDE;
                }
                citizen = (Optional)workers.get(0);
            }
            citizen.ifPresent(abstractEntityCitizen -> {
                this.citizenToGatherFrom = abstractEntityCitizen.getCitizenData();
            });
            this.progressTicks = 0;
            return this.getState();
        }
        if (!this.citizenToGatherFrom.getCitizenEntity().isPresent()) {
            this.citizenToGatherFrom = null;
            return this.getState();
        }
        if (this.progressTicks == 0 && BlockPosUtil.getDistance2D(this.citizenToGatherFrom.getCitizenEntity().get().func_180425_c(), this.worker.func_180425_c()) > 5L) {
            if (!((JobEnchanter)this.job).incrementWaitingTicks()) {
                this.resetDraining();
                return AIWorkerState.DECIDE;
            }
            return this.getState();
        }
        ++this.progressTicks;
        int maxDrain = Math.min(this.getOwnBuilding(BuildingEnchanter.class).getDailyDrain(), this.citizenToGatherFrom.getLevel());
        if (this.progressTicks < 20 * maxDrain) {
            Vec3d start = this.worker.func_174791_d().func_72441_c(0.0, 2.0, 0.0);
            Vec3d goal = this.citizenToGatherFrom.getCitizenEntity().get().func_174791_d().func_72441_c(0.0, 2.0, 0.0);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new StreamParticleEffectMessage(start, goal, EnumParticleTypes.ENCHANTMENT_TABLE, this.progressTicks % 20, 20), (Entity)this.worker);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new CircleParticleEffectMessage(start, EnumParticleTypes.VILLAGER_HAPPY, this.progressTicks), (Entity)this.worker);
            WorkerUtil.faceBlock(new BlockPos(goal), this.worker);
            return this.getState();
        }
        if (this.worker.getRandom().nextBoolean()) {
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
        } else {
            this.worker.func_184609_a(EnumHand.OFF_HAND);
        }
        int size = this.citizenToGatherFrom.getInventory().func_70302_i_();
        int attempts = ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel();
        for (int i = 0; i < attempts; ++i) {
            int randomSlot = this.worker.getRandom().nextInt(size);
            ItemStack stack = this.citizenToGatherFrom.getInventory().func_70301_a(randomSlot);
            if (stack.func_190926_b() || !stack.func_77956_u()) continue;
            EnchantmentHelper.func_77504_a((Random)this.worker.getRandom(), (ItemStack)stack, (int)1, (boolean)false);
            break;
        }
        this.worker.getCitizenData().addExperience(this.citizenToGatherFrom.drainExperience(maxDrain));
        while (ExperienceUtils.getXPNeededForNextLevel(this.worker.getCitizenData().getLevel()) < this.worker.getCitizenData().getExperience()) {
            this.worker.getCitizenData().levelUp();
        }
        this.worker.getCitizenExperienceHandler().updateLevel();
        this.worker.getCitizenData().markDirty();
        this.resetDraining();
        return AIWorkerState.IDLE;
    }

    private void resetDraining() {
        this.getOwnBuilding(BuildingEnchanter.class).setAsGathered(((JobEnchanter)this.job).getPosToDrainFrom());
        this.citizenToGatherFrom = null;
        ((JobEnchanter)this.job).setBuildingToDrainFrom(null);
        this.progressTicks = 0;
        this.incrementActionsDoneAndDecSaturation();
    }
}

