/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.achievements.ModAchievements;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class GuardArrow
extends EntityTippedArrow {
    private static final String TAG_COLONY = "colony";
    private IColony colony;

    public GuardArrow(World worldin) {
        super(worldin);
    }

    public GuardArrow(World worldIn, AbstractEntityCitizen shooter) {
        super(worldIn, (EntityLivingBase)shooter);
        this.colony = shooter.getCitizenColonyHandler().getColony();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(TAG_COLONY, this.colony.getID());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        int colonyID = compound.func_74762_e(TAG_COLONY);
        this.colony = IColonyManager.getInstance().getColonyByWorld(colonyID, this.field_70170_p);
    }

    protected void func_184548_a(EntityLivingBase targetEntity) {
        super.func_184548_a(targetEntity);
        if (targetEntity.func_110143_aJ() <= 0.0f) {
            if (targetEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)targetEntity;
                if (this.colony.getPermissions().isColonyMember(player)) {
                    this.colony.getStatsManager().triggerAchievement(ModAchievements.achievementPlayerDeathGuard);
                }
            }
            this.colony.getStatsManager().incrementStatistic("mobs");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuardArrow)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GuardArrow that = (GuardArrow)((Object)o);
        return this.colony == null ? that.colony != null : this.colony.equals(that.colony);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.colony != null ? this.colony.hashCode() : 0);
        return result;
    }
}

