/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class LocalizedParticleEffectMessage
extends AbstractMessage<LocalizedParticleEffectMessage, IMessage> {
    private static final Random RAND = new Random();
    private ItemStack stack;
    private double posX;
    private double posY;
    private double posZ;

    public LocalizedParticleEffectMessage() {
    }

    public LocalizedParticleEffectMessage(ItemStack stack, BlockPos pos) {
        this.stack = stack;
        this.posX = (double)pos.func_177958_n() + 0.5;
        this.posY = (double)pos.func_177956_o() + 0.5;
        this.posZ = (double)pos.func_177952_p() + 0.5;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    @Override
    protected void messageOnClientThread(LocalizedParticleEffectMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack localStack = message.stack;
        for (int i = 0; i < 5; ++i) {
            Vec3d randomPos = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() * 0.1 + 0.1, 0.0);
            Vec3d randomOffset = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() - 0.05, (RAND.nextDouble() - 0.5) * 0.1);
            if (localStack.func_77981_g()) {
                world.func_175688_a(EnumParticleTypes.ITEM_CRACK, message.posX + randomOffset.field_72450_a, message.posY + randomOffset.field_72448_b, message.posZ + randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[]{Item.func_150891_b((Item)localStack.func_77973_b()), localStack.func_77960_j()});
                continue;
            }
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, message.posX + randomOffset.field_72450_a, message.posY + randomOffset.field_72448_b, message.posZ + randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[]{Item.func_150891_b((Item)localStack.func_77973_b())});
        }
    }
}

