/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WorkOrderChangeMessage
extends AbstractMessage<WorkOrderChangeMessage, IMessage> {
    private int colonyId;
    private int workOrderId;
    private int priority;
    private boolean removeWorkOrder;
    private int dimension;

    public WorkOrderChangeMessage() {
    }

    public WorkOrderChangeMessage(@NotNull IBuildingView building, int workOrderId, boolean removeWorkOrder, int priority) {
        this.colonyId = building.getColony().getID();
        this.workOrderId = workOrderId;
        this.removeWorkOrder = removeWorkOrder;
        this.priority = priority;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
        this.priority = buf.readInt();
        this.removeWorkOrder = buf.readBoolean();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.removeWorkOrder);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(WorkOrderChangeMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            if (message.removeWorkOrder) {
                colony.getWorkManager().removeWorkOrder(message.workOrderId);
            } else if (colony.getWorkManager().getWorkOrder(message.workOrderId) != null) {
                colony.getWorkManager().getWorkOrder(message.workOrderId).setPriority(message.priority);
            }
        }
    }
}

