/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.interactionhandling.registry.InteractionResponseHandlerEntry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityEnchanter;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.api.util.constant.LootTableConstants;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import com.minecolonies.apiimp.initializer.ModBlocksInitializer;
import com.minecolonies.apiimp.initializer.ModBuildingsInitializer;
import com.minecolonies.apiimp.initializer.ModColonyEventTypeInitializer;
import com.minecolonies.apiimp.initializer.ModGuardTypesInitializer;
import com.minecolonies.apiimp.initializer.ModInteractionsInitializer;
import com.minecolonies.apiimp.initializer.ModItemsInitializer;
import com.minecolonies.apiimp.initializer.ModJobsInitializer;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenary;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityPirate;
import com.minecolonies.coremod.inventory.GuiHandler;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.tileentities.TileEntityBarrel;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import com.minecolonies.coremod.util.TownHallRecipe;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public abstract class CommonProxy
implements IProxy {
    static CommonMinecoloniesAPIImpl apiImpl;
    private static final int PRIMARY_COLOR_BARBARIAN = 5;
    private static final int SECONDARY_COLOR_BARBARIAN = 700;
    private static final int PRIMARY_COLOR_PIRATE = 7;
    private static final int SECONDARY_COLOR_PIRATE = 600;
    private static final Map<String, NBTTagCompound> playerPropertiesData;
    private int nextEntityId = 0;

    CommonProxy() {
        apiImpl = new CommonMinecoloniesAPIImpl();
    }

    public static void storeEntityData(String name, NBTTagCompound compound) {
        playerPropertiesData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        ModBlocksInitializer.init((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerRecipes(@NotNull RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new TownHallRecipe());
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        ModItemsInitializer.init((IForgeRegistry<Item>)event.getRegistry());
        ModBlocksInitializer.registerItemBlock((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerBuildingTypes(@NotNull RegistryEvent.Register<BuildingEntry> event) {
        ModBuildingsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerRaidEventTypes(@NotNull RegistryEvent.Register<ColonyEventTypeRegistryEntry> event) {
        ModColonyEventTypeInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerJobTypes(RegistryEvent.Register<JobEntry> event) {
        ModJobsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerGuardTypes(RegistryEvent.Register<GuardType> event) {
        ModGuardTypesInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerNewRegistries(RegistryEvent.NewRegistry event) {
        apiImpl.registerCustomRegistries(event);
    }

    @Override
    public void setupApi() {
        MinecoloniesAPIProxy.getInstance().setApiInstance(apiImpl);
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @SubscribeEvent
    public static void registerInteractionTypes(@NotNull RegistryEvent.Register<InteractionResponseHandlerEntry> event) {
        ModInteractionsInitializer.init(event);
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityColonyBuilding.class, (ResourceLocation)new ResourceLocation("minecolonies", "colonybuilding"));
        GameRegistry.registerTileEntity(TileEntityScarecrow.class, (ResourceLocation)new ResourceLocation("minecolonies", "scarecrow"));
        GameRegistry.registerTileEntity(TileEntityWareHouse.class, (ResourceLocation)new ResourceLocation("minecolonies", "warehouse"));
        GameRegistry.registerTileEntity(TileEntityRack.class, (ResourceLocation)new ResourceLocation("minecolonies", "rack"));
        GameRegistry.registerTileEntity(TileEntityInfoPoster.class, (ResourceLocation)new ResourceLocation("minecolonies", "infoposter"));
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (ResourceLocation)new ResourceLocation("minecolonies", "barrel"));
        GameRegistry.registerTileEntity(TileEntityDecorationController.class, (ResourceLocation)new ResourceLocation("minecolonies", "decorationcontroller"));
        GameRegistry.registerTileEntity(TileEntityCompostedDirt.class, (ResourceLocation)new ResourceLocation("minecolonies:CompostedDirt"));
        GameRegistry.registerTileEntity(TileEntityEnchanter.class, (ResourceLocation)new ResourceLocation("minecolonies", "enchanter"));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MineColonies.instance, (IGuiHandler)new GuiHandler());
    }

    @Override
    public void registerEvents() {
    }

    @Override
    public void registerEntities() {
        ResourceLocation locationCitizen = new ResourceLocation("minecolonies", "Citizen");
        ResourceLocation locationFishHook = new ResourceLocation("minecolonies", "Fishhook");
        EntityRegistry.registerModEntity((ResourceLocation)locationCitizen, EntityCitizen.class, (String)"Citizen", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)locationFishHook, EntityFishHook.class, (String)"Fishhook", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.BARBARIAN, EntityBarbarian.class, (String)"Barbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.MERCENARY, EntityMercenary.class, (String)"Mercenary", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.SITTING_ENTITY, SittingEntity.class, (String)"SITTING_ENTITY", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.ARCHER, EntityArcherBarbarian.class, (String)"ArcherBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.CHIEF, EntityChiefBarbarian.class, (String)"ChiefBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE, EntityPirate.class, (String)"Pirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE_ARCHER, EntityArcherPirate.class, (String)"ArcherPirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE_CHIEF, EntityCaptainPirate.class, (String)"ChiefPirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.MELEE_BARBARIAN_DROPS);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.ARCHER_BARBARIAN_DROPS);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.CHIEF_BARBARIAN_DROPS);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.MELEE_PIRATE_DROPS);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.ARCHER_PIRATE_DROPS);
        LootTableList.func_186375_a((ResourceLocation)LootTableConstants.CHIEF_PIRATE_DROPS);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.BARBARIAN, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.ARCHER, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.CHIEF, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE, (int)7, (int)600);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE_ARCHER, (int)7, (int)600);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE_CHIEF, (int)7, (int)600);
    }

    @Override
    public void registerEntityRendering() {
    }

    @Override
    public void registerTileEntityRendering() {
    }

    @Override
    public void showCitizenWindow(ICitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openSuggestionWindow(@NotNull BlockPos pos, @NotNull IBlockState state, @NotNull ItemStack stack) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation, WindowBuildTool.FreeMode mode) {
    }

    @Override
    public void openClipBoardWindow(int colonyId) {
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos pos) {
    }

    @Override
    public void registerRenderer() {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getServerHandler().field_147369_b.func_71121_q();
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }

    private int getNextEntityId() {
        return this.nextEntityId++;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull EntityPlayer player) {
        return ((EntityPlayerMP)player).func_192037_E();
    }

    @Override
    public void openDecorationControllerWindow(@NotNull BlockPos pos) {
    }

    static {
        playerPropertiesData = new HashMap<String, NBTTagCompound>();
    }
}

