/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.util.BackUpHelper;
import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ChunkDataHelper {
    private static final int DISTANCE_TO_DELETE = Configurations.gameplay.workingRangeTownHallChunks * 16 * 2 * 5;

    private ChunkDataHelper() {
    }

    public static void loadChunk(Chunk chunk, World world) {
        IColony colony;
        IColonyTagCapability closeCap;
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyTagCapability closeCap2;
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            } else if (Configurations.gameplay.fixOrphanedChunks && (closeCap2 = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)) != null) {
                boolean dirty = false;
                for (int colony2 : closeCap2.getAllCloseColonies()) {
                    if (colony2 == 0 || cap.getColony(colony2) != null && BlockPosUtil.getDistance2D(cap.getColony(colony2).getCenter(), new BlockPos(chunk.field_76635_g * 16, 0, chunk.field_76647_h * 16)) <= (long)DISTANCE_TO_DELETE) continue;
                    Log.getLogger().warn("Removing orphaned chunk at:  " + chunk.field_76635_g * 16 + " 100 " + chunk.field_76647_h * 16);
                    closeCap2.removeColony(colony2, chunk);
                    dirty = true;
                }
                if (dirty) {
                    MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(closeCap2, chunk.field_76635_g, chunk.field_76647_h));
                }
            }
        }
        if ((closeCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)) != null && closeCap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeCap.getOwningColony(), world.field_73011_w.getDimension())) != null) {
            colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
        }
    }

    public static void unloadChunk(Chunk chunk, World world) {
        IColony colony;
        IColonyTagCapability closeCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (closeCap != null && closeCap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeCap.getOwningColony(), world.field_73011_w.getDimension())) != null) {
            colony.removeLoadedChunk(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
        }
    }

    public static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    public static void loadChunkStorageToWorldCapability(World world) {
        File chunkDir = new File(world.func_72860_G().func_75765_b(), "minecolonies/chunkInfo");
        if (!chunkDir.exists()) {
            return;
        }
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        File[] files = chunkDir.listFiles();
        if (files != null) {
            for (File file : files) {
                NBTTagCompound chunkData = BackUpHelper.loadNBTFromPath(file);
                if (chunkData == null) continue;
                ChunkLoadStorage storage = new ChunkLoadStorage(chunkData);
                int z = (int)(storage.getXz() >> 32);
                int x = (int)storage.getXz();
                chunkManager.addChunkStorage(x, z, storage);
                file.delete();
            }
        }
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center, int dimension) {
        int range = Configurations.gameplay.workingRangeTownHallChunks;
        int buffer = Configurations.gameplay.townHallPaddingChunk;
        ChunkDataHelper.claimChunksInRange(id, dimension, add, center, range, buffer, world);
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center, int dimension, int range) {
        ChunkDataHelper.claimChunksInRange(id, dimension, add, range, world, center);
    }

    public static boolean canClaimChunksInRange(World w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = (IChunkmanagerCapability)w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        int chunkX = centralChunk.field_76635_g;
        int chunkZ = centralChunk.field_76647_h;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                Chunk chunk = w.func_72964_e(i, j);
                IColonyTagCapability colonyCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
                if (colonyCap == null) {
                    return false;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void claimChunksInRange(int colonyId, int dimension, boolean add, int range, World world, BlockPos center) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, colonyId, center, chunkManager);
        int chunkX = centralChunk.field_76635_g;
        int chunkZ = centralChunk.field_76647_h;
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, world);
        if (colony == null) {
            return;
        }
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (Configurations.gameplay.workingRangeTownHall != 0 && pos.func_177951_i((Vec3i)colony.getCenter()) > Math.pow(Configurations.gameplay.workingRangeTownHall * 16, 2.0)) {
                    Log.getLogger().warn("Tried to claim chunk at pos X:" + pos.func_177958_n() + " Z:" + pos.func_177952_p() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (i == chunkX && j == chunkZ || ChunkDataHelper.loadChunkAndAddData(world, pos, add, colonyId, center, chunkManager)) continue;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), dimension, center);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
    }

    public static void claimChunksInRange(int colonyId, int dimension, boolean add, BlockPos center, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, colonyId, chunkManager);
        int chunkX = centralChunk.field_76635_g;
        int chunkZ = centralChunk.field_76647_h;
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i == chunkX && j == chunkZ || i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ChunkDataHelper.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId, chunkManager)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), add, dimension, owning);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
    }

    public static void debugChunksInRange(int chunkX, int chunkZ, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                Chunk chunk = world.func_175726_f(pos);
                if (((IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() == 0) continue;
                Log.getLogger().warn("Has owner: " + pos.toString());
            }
        }
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, IChunkmanagerCapability chunkManager) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (cap.getOwningColony() == id && add) {
            return true;
        }
        if (add) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, world.field_73011_w.getDimension());
            if (colony != null) {
                colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
            }
            cap.setOwningColony(id, chunk);
            cap.addColony(id, chunk);
        } else {
            cap.removeColony(id, chunk);
        }
        MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        return true;
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(id, buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(id, buildingPos, chunk);
        }
        MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        return true;
    }
}

