/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import shadows.endertweaker.EnderTweaker;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.Enchanter")
@ZenRegister
public class Enchanter {
    @ZenMethod
    public static void addRecipe(IEnchantmentDefinition output, IIngredient input, int amountPerLevel, double costMultiplier) {
        if (output == null) {
            CraftTweakerAPI.logError((String)"Cannot add recipe for null to enchanter.");
            return;
        }
        if (input == null) {
            CraftTweakerAPI.logError((String)("Cannot add recipe for " + output.getTranslatedName(1) + " with null input to enchanter."));
            return;
        }
        EnderTweaker.ADDITIONS.add(() -> {
            Things thing = new Things();
            thing.add(new NNList((Object[])CraftTweakerMC.getIngredient((IIngredient)input).func_193365_a()));
            Enchantment enchantment = (Enchantment)output.getInternal();
            if (!thing.isEmpty() && enchantment != null) {
                EnchanterRecipe recipe = new EnchanterRecipe(thing, amountPerLevel, enchantment, costMultiplier);
                MachineRecipeRegistry.instance.registerRecipe("enchanter", (IMachineRecipe)recipe);
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IEnchantmentDefinition output) {
        if (output == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from enchanter.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            Enchantment ench = (Enchantment)output.getInternal();
            String id = null;
            for (Map.Entry ent : MachineRecipeRegistry.instance.getRecipesForMachine("enchanter").entrySet()) {
                if (((EnchanterRecipe)ent.getValue()).getEnchantment() != ench) continue;
                id = (String)ent.getKey();
                break;
            }
            if (id != null) {
                MachineRecipeRegistry.instance.getRecipesForMachine("enchanter").remove(id);
            } else {
                CraftTweakerAPI.logError((String)("No Enchanter recipe found for " + output.getName()));
            }
        });
    }
}

