/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.tank.TankMachineRecipe;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import shadows.endertweaker.EnderTweaker;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.Tank")
@ZenRegister
public class Tank {
    static int k = 0;

    @ZenMethod
    public static void addRecipe(boolean fill, IIngredient input, ILiquidStack fluid, IItemStack output) {
        EnderTweaker.ADDITIONS.add(() -> {
            Things in = new Things().add(new NNList((Object[])CraftTweakerMC.getIngredient((IIngredient)input).func_193365_a()));
            Things out = new Things().add(CraftTweakerMC.getItemStack((IItemStack)output));
            TankMachineRecipe rec = new TankMachineRecipe("tank_recipe_" + k++, fill, in, CraftTweakerMC.getLiquidStack((ILiquidStack)fluid), out, TankMachineRecipe.Logic.NONE, RecipeLevel.IGNORE);
            MachineRecipeRegistry.instance.registerRecipe((IMachineRecipe)rec);
        });
    }

    @ZenMethod
    public static void removeRecipe(boolean fill, ILiquidStack fluid, IItemStack output) {
        if (output == null || fluid == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from tank.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            String rec = null;
            String id = fill ? "tankfill" : "tankempty";
            for (Map.Entry ent : MachineRecipeRegistry.instance.getRecipesForMachine(id).entrySet()) {
                TankMachineRecipe r = (TankMachineRecipe)ent.getValue();
                if (!r.getFluid().getFluid().getName().equals(fluid.getName()) || !OreDictionary.itemMatches((ItemStack)CraftTweakerMC.getItemStack((IItemStack)output), (ItemStack)r.getOutput().func_193365_a()[0], (boolean)false)) continue;
                rec = (String)ent.getKey();
                break;
            }
            if (rec != null) {
                MachineRecipeRegistry.instance.getRecipesForMachine(id).remove(rec);
            } else {
                CraftTweakerAPI.logError((String)("No tank recipe found for " + output.getName() + " | " + fluid.getName()));
            }
        });
    }
}

