/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WPage;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class GuiLabel
extends WContainer
implements IGui {
    WContainer container = new WContainer();
    Consumer<ILabel> callback;
    LoadingCache<Integer, IWidget> cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(16L).weigher((key, value) -> 1).build((CacheLoader)new CacheLoader<Integer, IWidget>(){

        public IWidget load(Integer i) {
            ILabel.RegistryEditor.Record record = ILabel.EDITOR.getRecords().get(i);
            return record.editor.get().setCallback(GuiLabel.this.callback);
        }
    });

    public GuiLabel(Consumer<ILabel> callback) {
        this.callback = callback;
        Wrapper<Integer> index = new Wrapper<Integer>(0);
        ILabel.EDITOR.getRecords().forEach(r -> {
            int i = (Integer)index.value;
            this.add((IWidget)new WPage(i, (ILabel.RegistryEditor.Record)r, false).setListener(j -> this.refresh(i)));
            index.value = (Integer)index.value + 1;
        });
        this.add(new WHelp("label"), new WPanel());
        this.add((IWidget)this.container);
        this.refresh(0);
    }

    protected void refresh(int index) {
        this.container.clear();
        this.container.add((IWidget)this.cache.getUnchecked((Object)index));
        this.container.add((IWidget)new WPage(index, ILabel.EDITOR.getRecords().get(index), true));
    }
}

