/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis.pickers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LOreDict;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WSearch;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class PickerSimple
extends IPicker.Impl
implements IGui {
    public PickerSimple(List<ILabel> labels) {
        WLabelScroll ls = new WLabelScroll(7, 33, 8, 7, WLabel.Mode.PICKER, true).setLabels(labels).setListener((i, v) -> this.notifyLsnr(i.get((int)v)));
        this.add((IWidget)new WSearch(26, 7, 90, ls));
        this.add((IWidget)new WIcon(7, 7, 20, 20, Resource.ICN_TEXT, "common.search"));
        this.add((IWidget)ls);
    }

    public static class OreDict
    extends PickerSimple {
        public OreDict() {
            super(OreDict.generate());
        }

        static List<ILabel> generate() {
            return Arrays.stream(OreDictionary.getOreNames()).filter(i -> !OreDictionary.getOres((String)i).isEmpty()).map(LOreDict::new).collect(Collectors.toList());
        }
    }

    public static class FluidStack
    extends PickerSimple {
        public FluidStack() {
            super(FluidRegistry.getRegisteredFluids().entrySet().stream().map(e -> new LFluidStack(1000L, (Fluid)e.getValue())).collect(Collectors.toList()));
        }
    }
}

