/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Utilities {
    public static char[] suffix = new char[]{'K', 'M', 'B', 'G', 'T', 'P'};
    public static DecimalFormat[] format = new DecimalFormat[]{new DecimalFormat("#."), new DecimalFormat("#.#"), new DecimalFormat("#.##"), new DecimalFormat("#.###"), new DecimalFormat("#.####")};

    public static String cutNumber(float f, int size) {
        BiFunction<Float, Integer, String> form = (fl, len) -> format[len - 1 - (int)Math.log10(fl.floatValue())].format(fl);
        int scale = (int)Math.log10(f) / 3;
        if (scale == 0) {
            return form.apply(Float.valueOf(f), size);
        }
        return form.apply(Float.valueOf(f / (float)Math.pow(1000.0, scale)), size - 1) + suffix[scale - 1];
    }

    public static <T> Stream<T> stream(Optional<T> o) {
        return o.map(Stream::of).orElse(Stream.empty());
    }

    public static <T> Supplier<T> fake(Runnable r) {
        return () -> {
            r.run();
            return null;
        };
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Nullable
    public static String getModName(Item item) {
        ResourceLocation tmp = item.getRegistryName();
        if (tmp == null) {
            return null;
        }
        String id = tmp.func_110624_b();
        return id.equals("minecraft") ? "Minecraft" : ((ModContainer)Loader.instance().getIndexedModList().get(id)).getName();
    }

    public static String getModName(Fluid fluid) {
        String name = fluid.getName();
        if (name.equals("lava") || name.equals("water")) {
            return "Minecraft";
        }
        return ((ModContainer)Loader.instance().getIndexedModList().get(fluid.getStill().func_110624_b())).getName();
    }

    public static NBTTagCompound getTag(ItemStack is) {
        return is.func_190925_c("jecalculation");
    }

    public static class Json {
        @Nullable
        public static NBTTagCompound read(File f) {
            try {
                String s = FileUtils.readFileToString((File)f, (String)"UTF-8");
                return Json.read(s);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Nullable
        public static NBTTagCompound read(String s) {
            try {
                return JsonToNBT.func_180713_a((String)s);
            }
            catch (NBTException e) {
                e.printStackTrace();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(NBTTagCompound nbt, File f) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(Json.write(nbt).getBytes(Charset.forName("UTF-8")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public static String write(NBTTagCompound nbt) {
            Writer w = new Writer();
            Json.write((NBTBase)nbt, w);
            w.enter();
            return w.build();
        }

        private static void write(NBTBase nbt, Writer w) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound tags = (NBTTagCompound)nbt;
                boolean wrap = tags.func_150296_c().size() > 1;
                boolean first = true;
                w.sb.append('{');
                if (wrap) {
                    ++w.indent;
                }
                for (String i : tags.func_150296_c()) {
                    if (first) {
                        first = false;
                    } else {
                        w.sb.append(',');
                    }
                    if (wrap) {
                        w.enter();
                    }
                    w.sb.append('\"');
                    w.sb.append(i);
                    w.sb.append("\": ");
                    Json.write(tags.func_74781_a(i), w);
                }
                if (wrap) {
                    --w.indent;
                    w.enter();
                }
                w.sb.append('}');
            } else if (nbt instanceof NBTTagList) {
                NBTTagList tags = (NBTTagList)nbt;
                boolean wrap = tags.func_74745_c() > 1;
                boolean first = true;
                w.sb.append('[');
                if (wrap) {
                    ++w.indent;
                }
                for (NBTBase i : tags) {
                    if (first) {
                        first = false;
                    } else {
                        w.sb.append(',');
                    }
                    if (wrap) {
                        w.enter();
                    }
                    Json.write(i, w);
                }
                if (wrap) {
                    --w.indent;
                    w.enter();
                }
                w.sb.append(']');
            } else {
                w.sb.append(nbt.toString());
            }
        }

        private static class Writer {
            public int indent = 0;
            StringBuilder sb = new StringBuilder();

            private Writer() {
            }

            public void enter() {
                this.sb.append('\n');
                char[] tmp = new char[4 * this.indent];
                Arrays.fill(tmp, ' ');
                this.sb.append(tmp);
            }

            public String build() {
                return this.sb.toString();
            }
        }
    }

    public static class Recent<T> {
        LinkedList<T> data = new LinkedList();
        BiPredicate<T, T> tester;
        int limit;

        public Recent(BiPredicate<T, T> tester, int limit) {
            this.tester = tester;
            this.limit = limit;
        }

        public Recent(int limit) {
            this.limit = limit;
        }

        public boolean push(T obj, boolean replace) {
            if (replace) {
                this.data.pop();
            }
            boolean ret = this.data.removeIf(t -> this.tester != null ? this.tester.test(t, obj) : t.equals(obj));
            this.data.addFirst(obj);
            if (this.data.size() > this.limit) {
                this.data.removeLast();
            }
            return ret;
        }

        public List<T> toList() {
            return (List)this.data.clone();
        }

        public void clear() {
            this.data.clear();
        }

        public int size() {
            return this.data.size();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class I18n {
        public static boolean contains(String s1, String s2) {
            return s1.contains(s2);
        }

        public static Pair<String, Boolean> search(String translateKey, Object ... parameters) {
            Pair<Object, Object> ret = new Pair<Object, Object>(null, null);
            translateKey = "jecalculation." + translateKey;
            String buffer = net.minecraft.client.resources.I18n.func_135052_a((String)translateKey, (Object[])parameters);
            ret.two = !buffer.equals(translateKey);
            buffer = StringEscapeUtils.unescapeJava((String)buffer);
            ret.one = buffer.replace("\t", "    ");
            return ret;
        }

        public static String get(String translateKey, Object ... parameters) {
            return (String)I18n.search((String)translateKey, (Object[])parameters).one;
        }

        public static List<String> wrap(String s, int width) {
            return new TextWrapper().wrap(s, MinecraftForgeClient.getLocale(), i -> TextWrapper.renderer.func_78263_a(i.charValue()), width);
        }

        static class TextWrapper {
            static FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            String str;
            BreakIterator it;
            List<String> temp = new ArrayList<String>();
            Function<Character, Integer> func;
            int start;
            int end;
            int section;
            int space;
            int cursor;
            int width;

            TextWrapper() {
            }

            private void cut() {
                char c = this.str.charAt(this.cursor);
                if (c == '\f') {
                    ++this.cursor;
                }
                this.temp.add(this.str.substring(this.start, this.cursor));
                if (c == ' ' || c == '\u3000' || c == '\n') {
                    ++this.cursor;
                }
                this.start = this.cursor;
                this.end = this.cursor;
                this.space = this.width;
                this.section = this.func.apply(Character.valueOf(this.str.charAt(this.cursor)));
            }

            private void move() {
                this.temp.add(this.str.substring(this.start, this.end));
                this.start = this.end;
                this.space = this.width;
            }

            private List<String> wrap(String s, Locale l, Function<Character, Integer> func, int width) {
                this.temp.clear();
                this.start = 0;
                this.end = 0;
                this.cursor = 0;
                this.space = width;
                this.str = s;
                this.it = BreakIterator.getLineInstance(l);
                this.it.setText(s);
                this.width = width;
                this.func = func;
                int i = this.it.next();
                while (i != -1) {
                    this.cursor = this.end;
                    while (this.cursor < i) {
                        char ch = this.str.charAt(this.cursor);
                        this.section += func.apply(Character.valueOf(this.str.charAt(this.cursor))).intValue();
                        if (ch == '\n' || ch == '\f') {
                            this.cut();
                        } else if (this.section > this.space) {
                            if (this.start == this.end) {
                                this.cut();
                            } else {
                                this.move();
                            }
                        }
                        ++this.cursor;
                    }
                    this.space -= this.section;
                    this.section = 0;
                    this.end = this.cursor;
                    i = this.it.next();
                }
                this.move();
                return this.temp;
            }
        }
    }

    public static class ReversedIterator<T>
    implements Iterator<T> {
        ListIterator<T> i;

        public ReversedIterator(List<T> l) {
            this.i = l.listIterator(l.size());
        }

        @Override
        public boolean hasNext() {
            return this.i.hasPrevious();
        }

        @Override
        public T next() {
            return this.i.previous();
        }

        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }

    public static class Circulator {
        int total;
        int current;

        public Circulator(int total) {
            this(total, 0);
        }

        public Circulator(int total, int current) {
            this.total = total;
            this.current = current;
        }

        public int next() {
            return this.current + 1 == this.total ? 0 : this.current + 1;
        }

        public int prev() {
            return this.current == 0 ? this.total - 1 : this.current - 1;
        }

        public Circulator move(int steps) {
            this.current += steps;
            this.current = this.current < 0 ? (this.current += -this.current / this.total * this.total + this.total) : (this.current %= this.total);
            return this;
        }

        public int current() {
            return this.current;
        }

        public Circulator set(int index) {
            if (index < 0 || index >= this.total) {
                throw new RuntimeException(String.format("Expected: [0, %d), given: %d.", this.total, index));
            }
            this.current = index;
            return this;
        }

        public Circulator copy() {
            return new Circulator(this.total).set(this.current);
        }
    }

    public static class Timer {
        long time = System.currentTimeMillis();
        boolean running = false;

        public void setState(boolean b) {
            if (!b && this.running) {
                this.running = false;
            }
            if (b && !this.running) {
                this.running = true;
                this.time = System.currentTimeMillis();
            }
        }

        public long getTime() {
            return this.running ? System.currentTimeMillis() - this.time : 0L;
        }
    }

    public static class Relation<K, V> {
        public HashMap<Pair<K, K>, V> data = new HashMap();

        public void put(K a, K b, V v) {
            Pair<K, K> pair = new Pair<K, K>(a, b);
            V tmp = this.data.get(pair);
            this.data.put(tmp == null ? new Pair<K, K>(b, a) : pair, v);
        }

        @Nullable
        public V get(K a, K b) {
            V ret = this.data.get(new Pair<K, K>(a, b));
            if (ret == null) {
                ret = this.data.get(new Pair<K, K>(b, a));
            }
            return ret;
        }
    }
}

