/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.entity;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.api.IMovingTile;
import com.elytradev.movingworld.common.chunk.ChunkIO;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import com.elytradev.movingworld.common.chunk.MovingWorldSizeOverflowException;
import com.elytradev.movingworld.common.chunk.assembly.AssembleResult;
import com.elytradev.movingworld.common.chunk.assembly.ChunkDisassembler;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunkServer;
import com.elytradev.movingworld.common.entity.MovingWorldCapabilities;
import com.elytradev.movingworld.common.entity.MovingWorldHandlerCommon;
import com.elytradev.movingworld.common.entity.MovingWorldInfo;
import com.elytradev.movingworld.common.util.AABBRotator;
import com.elytradev.movingworld.common.util.MathHelperMod;
import com.elytradev.movingworld.common.util.Vec3dMod;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMovingWorld
extends EntityBoat
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Boolean> IS_FLYING = EntityDataManager.func_187226_a(EntityMovingWorld.class, (DataSerializer)DataSerializers.field_187198_h);
    public EntityPlayer controllingPassenger;
    public float motionYaw;
    public EnumFacing frontDirection;
    public BlockPos riderDestination;
    public Entity prevRiddenByEntity;
    public boolean disassembling = false;
    protected float groundFriction;
    protected float horFriction;
    protected float vertFriction;
    protected int[] layeredBlockVolumeCount;
    protected boolean noControl;
    protected boolean syncPosWithServer;
    @SideOnly(value=Side.CLIENT)
    protected double controlPosRotationIncrements;
    @SideOnly(value=Side.CLIENT)
    protected double controlX;
    @SideOnly(value=Side.CLIENT)
    protected double controlY;
    @SideOnly(value=Side.CLIENT)
    protected double controlZ;
    @SideOnly(value=Side.CLIENT)
    protected double controlPitch;
    @SideOnly(value=Side.CLIENT)
    protected double controlYaw;
    @SideOnly(value=Side.CLIENT)
    protected double controlVelX;
    @SideOnly(value=Side.CLIENT)
    protected double controlVelY;
    @SideOnly(value=Side.CLIENT)
    protected double controlVelZ;
    private int disassembleTimer = 100;
    private MobileChunk mobileChunk;
    private MovingWorldInfo info = new MovingWorldInfo();
    private ChunkDisassembler disassembler;

    public EntityMovingWorld(World world) {
        super(world);
        if (world.field_72995_K) {
            this.initClient();
        } else {
            this.initCommon();
        }
        this.motionYaw = 0.0f;
        this.layeredBlockVolumeCount = null;
        this.frontDirection = EnumFacing.NORTH;
        this.groundFriction = 0.9f;
        this.horFriction = 0.994f;
        this.vertFriction = 0.95f;
        this.prevRiddenByEntity = null;
        this.field_70158_ak = true;
    }

    public static boolean isAABBInLiquidNotFall(World world, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int x = i; x < j; ++x) {
            for (int y = k; y < l; ++y) {
                for (int z = i1; z < j1; ++z) {
                    double d0;
                    int j2;
                    IBlockState blockState = world.func_180495_p(new BlockPos(x, y, z));
                    Block block = blockState.func_177230_c();
                    if (block == null || blockState.func_185904_a() != Material.field_151586_h && blockState.func_185904_a() != Material.field_151587_i || (j2 = block.func_176201_c(blockState)) >= 8 || !((d0 = (double)(y + 1) - (double)j2 / 8.0) >= aabb.field_72338_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.controllingPassenger == null;
    }

    public double getControlX() {
        return this.controlX;
    }

    public double getControlY() {
        return this.controlY;
    }

    public double getControlZ() {
        return this.controlZ;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public abstract MovingWorldHandlerCommon getHandler();

    public int[] getLayeredBlockVolumeCount() {
        return this.layeredBlockVolumeCount;
    }

    public void setLayeredBlockVolumeCount(int[] layeredBlockVolumeCount) {
        this.layeredBlockVolumeCount = layeredBlockVolumeCount;
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.mobileChunk = new MobileChunkClient(this.field_70170_p, this);
        this.initMovingWorldClient();
    }

    private void initCommon() {
        this.mobileChunk = new MobileChunkServer(this.field_70170_p, this);
        this.initMovingWorldCommon();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_FLYING, (Object)false);
        this.initMovingWorld();
    }

    public abstract void initMovingWorld();

    public abstract void initMovingWorldClient();

    public abstract void initMovingWorldCommon();

    public MobileChunk getMobileChunk() {
        return this.mobileChunk;
    }

    public void assembleResultEntity() {
    }

    public abstract MovingWorldCapabilities getCapabilities();

    public abstract void setCapabilities(MovingWorldCapabilities var1);

    public ChunkDisassembler getDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = new ChunkDisassembler(this);
        }
        return this.disassembler;
    }

    public MovingWorldInfo getInfo() {
        return this.info;
    }

    public void setInfo(MovingWorldInfo movingWorldInfo) {
        if (movingWorldInfo == null) {
            throw new NullPointerException("Cannot set null moving world info");
        }
        this.info = movingWorldInfo;
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        return this.getHandler().processInitialInteract(entityplayer, hand);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.mobileChunk.onChunkUnload();
        this.getCapabilities().clear();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.mobileChunk.isModified) {
            this.mobileChunk.isModified = false;
            this.getHandler().onChunkUpdate();
        }
    }

    public EntityBoat.Type func_184453_r() {
        return EntityBoat.Type.OAK;
    }

    public void setRotatedBoundingBox() {
        if (this.mobileChunk == null) {
            float hw = this.field_70130_N / 2.0f;
            this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw));
        } else {
            this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)this.mobileChunk.getCenterX(), this.field_70163_u, this.field_70161_v - (double)this.mobileChunk.getCenterZ(), this.field_70165_t + (double)this.mobileChunk.getCenterX(), this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)this.mobileChunk.getCenterZ()));
            this.func_174826_a(AABBRotator.rotateAABBAroundY(this.func_174813_aQ(), this.field_70165_t, this.field_70161_v, (float)Math.toRadians(this.field_70177_z)));
        }
    }

    public void func_70105_a(float w, float h) {
        if (w != this.field_70130_N || h != this.field_70131_O) {
            this.field_70130_N = w;
            this.field_70131_O = h;
            float hw = w / 2.0f;
            this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int inc, boolean control) {
        if (control && this.func_184179_bs() != null) {
            this.field_70169_q = this.field_70165_t = x;
            this.field_70167_r = this.field_70163_u = y;
            this.field_70166_s = this.field_70161_v = z;
            this.field_70177_z = yaw;
            this.field_70125_A = pitch;
            this.controlPosRotationIncrements = 0.0;
            this.func_70107_b(x, y, z);
            this.controlVelX = 0.0;
            this.field_70159_w = 0.0;
            this.controlVelY = 0.0;
            this.field_70181_x = 0.0;
            this.controlVelZ = 0.0;
            this.field_70179_y = 0.0;
        } else {
            if (this.noControl) {
                this.controlPosRotationIncrements = inc + 5;
            } else {
                double dx = x - this.field_70165_t;
                double dy = y - this.field_70163_u;
                double dz = z - this.field_70161_v;
                double d = dx * dx + dy * dy + dz * dz;
                if (d < 0.3) {
                    return;
                }
                this.syncPosWithServer = true;
                this.controlPosRotationIncrements = inc;
            }
            this.controlX = x;
            this.controlY = y;
            this.controlZ = z;
            this.controlYaw = yaw;
            this.controlPitch = pitch;
            this.field_70159_w = this.controlVelX;
            this.field_70181_x = this.controlVelY;
            this.field_70179_y = this.controlVelZ;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.controlVelX = this.field_70159_w = x;
        this.controlVelY = this.field_70181_x = y;
        this.controlVelZ = this.field_70179_y = z;
    }

    public boolean posChanged() {
        return this.field_70165_t != this.field_70169_q || this.field_70163_u != this.field_70167_r || this.field_70161_v != this.field_70166_s;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double horvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles(horvel);
        }
        if (this.field_70170_p.field_72995_K && (this.noControl || this.syncPosWithServer)) {
            this.handleClientUpdate();
            if (this.controlPosRotationIncrements == 0.0) {
                this.syncPosWithServer = false;
            }
        } else {
            this.handleServerUpdate(horvel);
        }
        if (this.disassembling) {
            if (this.disassembleTimer <= 0) {
                this.disassembling = false;
                this.disassembleTimer = 100;
            } else {
                --this.disassembleTimer;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleClientUpdate() {
        if (this.controlPosRotationIncrements > 0.0) {
            double dx = this.field_70165_t + (this.controlX - this.field_70165_t) / this.controlPosRotationIncrements;
            double dy = this.field_70163_u + (this.controlY - this.field_70163_u) / this.controlPosRotationIncrements;
            double dz = this.field_70161_v + (this.controlZ - this.field_70161_v) / this.controlPosRotationIncrements;
            double ang = MathHelper.func_76138_g((double)(this.controlYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + ang / this.controlPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.controlPitch - (double)this.field_70125_A) / this.controlPosRotationIncrements);
            this.controlPosRotationIncrements -= 1.0;
            this.func_70107_b(dx, dy, dz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72866_a((Entity)this, false);
        } else {
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            this.field_70170_p.func_72866_a((Entity)this, false);
            if (this.field_70122_E) {
                this.field_70159_w *= (double)this.groundFriction;
                this.field_70181_x *= (double)this.groundFriction;
                this.field_70179_y *= (double)this.groundFriction;
            }
            this.field_70159_w *= (double)this.horFriction;
            this.field_70181_x *= (double)this.vertFriction;
            this.field_70179_y *= (double)this.horFriction;
        }
        this.setRotatedBoundingBox();
    }

    protected void handleServerUpdate(double horvel) {
        if (this.getMobileChunk() != null) {
            if (!this.getMobileChunk().movingWorldTileEntities.isEmpty()) {
                for (IMovingTile movingWorldTileEntity : this.getMobileChunk().movingWorldTileEntities) {
                    movingWorldTileEntity.tick(this.getMobileChunk());
                }
            }
            if (!this.getMobileChunk().updatableTiles.isEmpty()) {
                for (TileEntity tickable : Lists.newArrayList(this.getMobileChunk().updatableTiles)) {
                    tickable.func_145834_a((World)this.mobileChunk.getFakeWorld());
                    ((ITickable)tickable).func_73660_a();
                    tickable.func_145834_a(this.mobileChunk.world);
                }
            }
        }
        float gravity = 0.05f;
        if (!this.isFlying()) {
            this.field_70181_x -= (double)gravity;
        }
        this.handleControl(horvel);
        double newhorvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double maxvel = this.getCapabilities().getSpeedLimit();
        if (newhorvel > maxvel) {
            double d = maxvel / newhorvel;
            this.field_70159_w *= d;
            this.field_70179_y *= d;
            newhorvel = maxvel;
        }
        this.field_70181_x = MathHelperMod.clamp_double(this.field_70181_x, -maxvel, maxvel);
        if (this.field_70122_E) {
            this.field_70159_w *= (double)this.groundFriction;
            this.field_70181_x *= (double)this.groundFriction;
            this.field_70179_y *= (double)this.groundFriction;
        }
        this.field_70125_A += (this.motionYaw * this.getCapabilities().getBankingMultiplier() - this.field_70125_A) * 0.15f;
        this.motionYaw *= 0.7f;
        this.field_70177_z += this.motionYaw;
        this.setRotatedBoundingBox();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70163_u = Math.min(this.field_70163_u, (double)this.field_70170_p.func_72800_K());
        this.field_70159_w *= (double)this.horFriction;
        this.field_70181_x *= (double)this.vertFriction;
        this.field_70179_y *= (double)this.horFriction;
        this.handleServerUpdatePreRotation();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.handleCollision(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void handleServerUpdatePreRotation() {
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            this.updatePassengerPosition(passenger, this.riderDestination, 1);
        }
    }

    public boolean func_184196_w(Entity entity) {
        return Objects.equals(this.controllingPassenger, entity);
    }

    public void func_184226_ay() {
        this.updatePassengerPosition((Entity)this.controllingPassenger, this.riderDestination, 1);
        if (this.controllingPassenger != null) {
            this.controllingPassenger.func_184210_p();
        }
    }

    public void updatePassengerPosition(Entity passenger, BlockPos riderDestination, int flags) {
        if (passenger != null && !this.disassembling) {
            int frontDir = this.frontDirection.func_176736_b();
            float yaw = (float)Math.toRadians(this.field_70177_z);
            float pitch = (float)Math.toRadians(this.field_70125_A);
            int x1 = riderDestination.func_177958_n();
            int y1 = riderDestination.func_177956_o();
            int z1 = riderDestination.func_177952_p();
            if ((flags & 1) == 1) {
                if (frontDir == 0) {
                    --z1;
                } else if (frontDir == 1) {
                    ++x1;
                } else if (frontDir == 2) {
                    ++z1;
                } else if (frontDir == 3) {
                    --x1;
                }
                IBlockState state = this.mobileChunk.func_180495_p(new BlockPos(x1, MathHelper.func_76128_c((double)((double)y1 + this.func_70042_X() + passenger.func_70033_W())), z1));
                if (state.func_185914_p()) {
                    x1 = riderDestination.func_177958_n();
                    y1 = riderDestination.func_177956_o();
                    z1 = riderDestination.func_177952_p();
                }
            }
            double yOff = (flags & 2) == 2 ? 0.0 : this.func_70042_X();
            Vec3dMod vec = new Vec3dMod((double)((float)x1 - this.mobileChunk.getCenterX()) + 0.5, (double)(y1 - this.mobileChunk.minY()) + yOff, (double)((float)z1 - this.mobileChunk.getCenterZ()) + 0.5);
            switch (frontDir) {
                case 0: {
                    vec = vec.rotateAroundZ(-pitch);
                    break;
                }
                case 1: {
                    vec = vec.rotateAroundX(pitch);
                    break;
                }
                case 2: {
                    vec = vec.rotateAroundZ(pitch);
                    break;
                }
                case 3: {
                    vec = vec.rotateAroundX(-pitch);
                }
            }
            vec = vec.rotateAroundY(yaw);
            if ((flags & 1) == 1) {
                vec.func_72441_c(0.0, 0.25, 0.0);
            }
            passenger.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + passenger.func_70033_W(), this.field_70161_v + vec.field_72449_c);
            this.func_184454_a(passenger);
        }
    }

    protected void func_184454_a(Entity entityToUpdate) {
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.controllingPassenger;
    }

    public List<Entity> func_184188_bt() {
        if (this.controllingPassenger != null) {
            return Lists.newArrayList((Object[])new Entity[]{this.controllingPassenger});
        }
        return Collections.emptyList();
    }

    protected void func_184225_p(Entity passenger) {
        if (passenger.equals((Object)this.controllingPassenger)) {
            this.controllingPassenger = null;
        }
    }

    protected void func_184200_o(Entity passenger) {
        if (passenger.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.controllingPassenger == null && passenger != null && passenger instanceof EntityPlayer) {
            this.controllingPassenger = (EntityPlayer)passenger;
        }
    }

    private boolean handleCollision(double cPosX, double cPosY, double cPosZ) {
        boolean didCollide = false;
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.2, 0.0, 0.2));
            if (list != null && !list.isEmpty()) {
                didCollide = true;
                for (Entity entity : list) {
                    double d1;
                    double d0;
                    double d2;
                    if (Objects.equals(entity, this.func_184179_bs()) || !entity.func_70104_M()) continue;
                    if (entity instanceof EntityMovingWorld) {
                        entity.func_70108_f((Entity)this);
                        continue;
                    }
                    if (!(entity instanceof EntityBoat) || !((d2 = MathHelper.func_76132_a((double)(d0 = cPosX - entity.field_70165_t), (double)(d1 = cPosZ - entity.field_70161_v))) >= 0.01)) continue;
                    d2 = MathHelper.func_76133_a((double)d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= 0.05;
                    d1 *= 0.05;
                    entity.func_70024_g(-(d0 *= (double)(1.0f - entity.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entity.field_70144_Y)));
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(cPosX + ((double)(l % 2) - 0.5) * 0.8));
                int j1 = MathHelper.func_76128_c((double)(cPosZ + ((double)(l / 2) - 0.5) * 0.8));
                for (int k1 = 0; k1 < 2; ++k1) {
                    int l1 = MathHelper.func_76128_c((double)cPosY) + k1;
                    IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(i1, l1, j1));
                    Block block = blockState.func_177230_c();
                    if (block == Blocks.field_150433_aE) {
                        this.field_70170_p.func_175698_g(new BlockPos(i1, l1, j1));
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block == Blocks.field_150392_bi) {
                        this.field_70170_p.func_175655_b(new BlockPos(i1, l1, j1), true);
                        this.field_70123_F = false;
                        continue;
                    }
                    didCollide = true;
                }
            }
        }
        return didCollide;
    }

    public boolean func_70072_I() {
        float f = this.field_70130_N;
        this.field_70130_N = 0.0f;
        boolean ret = super.func_70072_I();
        this.field_70130_N = f;
        return ret;
    }

    public boolean isFlying() {
        return this.getCapabilities().canFly() && (Boolean)this.field_70180_af.func_187225_a(IS_FLYING) != false;
    }

    public void setFlying(boolean isFlying) {
        this.field_70180_af.func_187227_b(IS_FLYING, (Object)isFlying);
    }

    public abstract boolean isBraking();

    public boolean func_96092_aw() {
        return this.field_70173_aa > 60;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public double func_70042_X() {
        return this.func_70033_W() + 0.5;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return !this.field_70128_L && this.func_184179_bs() == null;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float getHorizontalVelocity() {
        return (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public void alignToGrid(boolean doPosAdjustment) {
        this.field_70177_z = (float)Math.round(this.field_70177_z / 90.0f) * 90.0f;
        this.field_70125_A = 0.0f;
        Vec3d vec = new Vec3d((double)(-this.mobileChunk.getCenterX()), (double)(-this.mobileChunk.minY()), (double)(-this.mobileChunk.getCenterZ()));
        vec = vec.func_178785_b((float)Math.toRadians(this.field_70177_z));
        int ix = MathHelperMod.round_double(vec.field_72450_a + this.field_70165_t);
        int iy = MathHelperMod.round_double(vec.field_72448_b + this.field_70163_u);
        int iz = MathHelperMod.round_double(vec.field_72449_c + this.field_70161_v);
        if (doPosAdjustment) {
            this.func_70634_a((double)ix - vec.field_72450_a, (double)iy - vec.field_72448_b, (double)iz - vec.field_72449_c);
        }
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public boolean disassemble(boolean overwrite) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.func_184232_k(this.func_184179_bs());
        ChunkDisassembler disassembler = this.getDisassembler();
        disassembler.overwrite = overwrite;
        if (!disassembler.canDisassemble(this.getAssemblyInteractor())) {
            return false;
        }
        AssembleResult result = disassembler.doDisassemble(this.getNewAssemblyInteractor());
        return true;
    }

    public abstract MovingWorldAssemblyInteractor getNewAssemblyInteractor();

    public void dropAsItems() {
        for (int i = this.mobileChunk.minX(); i < this.mobileChunk.maxX(); ++i) {
            for (int j = this.mobileChunk.minY(); j < this.mobileChunk.maxY(); ++j) {
                for (int k = this.mobileChunk.minZ(); k < this.mobileChunk.maxZ(); ++k) {
                    IBlockState blockState;
                    TileEntity tileentity = this.mobileChunk.func_175625_s(new BlockPos(i, j, k));
                    if (tileentity instanceof IInventory) {
                        IInventory inv = (IInventory)tileentity;
                        for (int it = 0; it < inv.func_70302_i_(); ++it) {
                            ItemStack is = inv.func_70301_a(it);
                            if (is == null) continue;
                            this.func_70099_a(is, 0.0f);
                        }
                    }
                    if ((blockState = this.mobileChunk.func_180495_p(new BlockPos(i, j, k))).func_177230_c() == Blocks.field_150350_a) continue;
                    blockState.func_177230_c().func_176226_b(this.field_70170_p, new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)), blockState, 0);
                }
            }
        }
    }

    protected void fillAirBlocks(Set<BlockPos> set, BlockPos pos) {
        if (pos.func_177958_n() < this.mobileChunk.minX() - 1 || pos.func_177958_n() > this.mobileChunk.maxX() || pos.func_177956_o() < this.mobileChunk.minY() - 1 || pos.func_177956_o() > this.mobileChunk.maxY() || pos.func_177952_p() < this.mobileChunk.minZ() - 1 || pos.func_177952_p() > this.mobileChunk.maxZ()) {
            return;
        }
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        if (this.mobileChunk.setBlockAsFilledAir(pos)) {
            this.fillAirBlocks(set, pos.func_177982_a(0, 1, 0));
            this.fillAirBlocks(set, pos.func_177982_a(-1, 0, 0));
            this.fillAirBlocks(set, pos.func_177982_a(0, 0, -1));
            this.fillAirBlocks(set, pos.func_177982_a(1, 0, 0));
            this.fillAirBlocks(set, pos.func_177982_a(0, 0, 1));
        }
    }

    public void setRiderDestination(EnumFacing frontDirection, BlockPos riderDestination) {
        this.frontDirection = frontDirection;
        this.riderDestination = riderDestination;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.mobileChunk.getMemoryUsage());
        DataOutputStream out = new DataOutputStream(baos);
        try {
            ChunkIO.writeAll(out, this.mobileChunk);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tag.func_74773_a("chunk", baos.toByteArray());
        tag.func_74768_a("riderDestinationX", this.riderDestination.func_177958_n());
        tag.func_74768_a("riderDestinationY", this.riderDestination.func_177956_o());
        tag.func_74768_a("riderDestinationZ", this.riderDestination.func_177952_p());
        tag.func_74768_a("front", this.frontDirection.func_176736_b());
        if (!this.mobileChunk.chunkTileEntityMap.isEmpty()) {
            NBTTagList tileEntities = new NBTTagList();
            for (TileEntity tileentity : this.mobileChunk.chunkTileEntityMap.values()) {
                NBTTagCompound comp = new NBTTagCompound();
                tileentity.func_189515_b(comp);
                tileEntities.func_74742_a((NBTBase)comp);
            }
            tag.func_74782_a("tileent", (NBTBase)tileEntities);
        }
        if (this.mobileChunk.marker != null) {
            NBTTagCompound markerComp = new NBTTagCompound();
            markerComp.func_74768_a("markerPosX", this.mobileChunk.marker.blockPos.func_177958_n());
            markerComp.func_74768_a("markerPosY", this.mobileChunk.marker.blockPos.func_177956_o());
            markerComp.func_74768_a("markerPosZ", this.mobileChunk.marker.blockPos.func_177952_p());
            tag.func_74782_a("markerInfo", (NBTBase)markerComp);
        }
        tag.func_74778_a("name", this.info.getName());
        if (this.info.getOwner() != null) {
            tag.func_74778_a("owner", this.info.getOwner().toString());
        }
        this.writeMovingWorldNBT(tag);
    }

    public abstract void writeMovingWorldNBT(NBTTagCompound var1);

    protected void func_70037_a(NBTTagCompound tag) {
        if (this.mobileChunk == null && this.field_70170_p != null) {
            if (this.field_70170_p.field_72995_K) {
                this.initClient();
            } else {
                this.initCommon();
            }
        }
        byte[] ab = tag.func_74770_j("chunk");
        ByteArrayInputStream bais = new ByteArrayInputStream(ab);
        DataInputStream in = new DataInputStream(bais);
        try {
            ChunkIO.read(in, this.mobileChunk);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tag.func_74764_b("riderDestination")) {
            short s = tag.func_74765_d("riderDestination");
            int rX = s & 0xF;
            int rY = s >>> 4 & 0xF;
            int rZ = s >>> 8 & 0xF;
            this.riderDestination = new BlockPos(rX, rY, rZ);
            this.frontDirection = EnumFacing.NORTH;
        } else {
            int rX = tag.func_74762_e("riderDestinationX");
            int rY = tag.func_74762_e("riderDestinationY");
            int rZ = tag.func_74762_e("riderDestinationZ");
            this.riderDestination = new BlockPos(rX, rY, rZ);
            this.frontDirection = EnumFacing.func_176731_b((int)tag.func_74762_e("front"));
        }
        NBTTagList tiles = tag.func_150295_c("tileent", 10);
        if (tiles != null) {
            for (int i = 0; i < tiles.func_74745_c(); ++i) {
                try {
                    NBTTagCompound comp = tiles.func_150305_b(i);
                    TileEntity tileentity = TileEntity.func_190200_a((World)this.mobileChunk.getFakeWorld(), (NBTTagCompound)comp);
                    this.mobileChunk.setTileEntity(tileentity.func_174877_v(), tileentity);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (tag.func_74764_b("markerInfo")) {
            NBTTagCompound markerComp = (NBTTagCompound)tag.func_74781_a("markerInfo");
            BlockPos markerPos = new BlockPos(markerComp.func_74762_e("markerPosX"), markerComp.func_74762_e("markerPosY"), markerComp.func_74762_e("markerPosZ"));
            this.mobileChunk.marker = new LocatedBlock(this.mobileChunk.func_180495_p(markerPos), this.mobileChunk.func_175625_s(markerPos), markerPos);
        }
        this.info = new MovingWorldInfo();
        this.info.setName(tag.func_74779_i("name"));
        if (tag.func_74764_b("owner")) {
            this.info.setOwner(UUID.fromString(tag.func_74779_i("owner")));
        }
        this.readMovingWorldNBT(tag);
    }

    public abstract void readMovingWorldNBT(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(double horvel) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.riderDestination.func_177958_n());
        data.writeInt(this.riderDestination.func_177956_o());
        data.writeInt(this.riderDestination.func_177952_p());
        data.writeInt(this.frontDirection.func_176736_b());
        data.writeShort(this.info.getName().length());
        data.writeBytes(this.info.getName().getBytes());
        try {
            ChunkIO.writeAllCompressed(data, this.mobileChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MovingWorldSizeOverflowException ssoe) {
            this.disassemble(false);
            MovingWorldMod.LOG.warn("Ship is too large to be sent");
        }
        this.writeMovingWorldSpawnData(data);
    }

    protected void func_71061_d_() {
        float sqrtMotion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * (double)0.2f + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * (double)0.2f)) * 0.2f;
        sqrtMotion = sqrtMotion > 1.0f ? 1.0f : sqrtMotion;
        this.func_184185_a(this.func_184181_aa(), sqrtMotion, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    public abstract void writeMovingWorldSpawnData(ByteBuf var1);

    public void readSpawnData(ByteBuf data) {
        int rX = data.readInt();
        int rY = data.readInt();
        int rZ = data.readInt();
        this.riderDestination = new BlockPos(rX, rY, rZ);
        this.frontDirection = EnumFacing.func_176731_b((int)data.readInt());
        byte[] ab = new byte[data.readShort()];
        data.readBytes(ab);
        this.info.setName(new String(ab));
        try {
            ChunkIO.readCompressed(data, this.mobileChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mobileChunk.onChunkLoad();
        this.readMovingWorldSpawnData(data);
    }

    public boolean func_145770_h(double camX, double camY, double camZ) {
        double d0 = this.field_70165_t - camX;
        double d1 = this.field_70163_u - camY;
        double d2 = this.field_70161_v - camZ;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.func_70112_a(d3);
    }

    public abstract void handleControl(double var1);

    public abstract void readMovingWorldSpawnData(ByteBuf var1);

    public abstract float getXRenderScale();

    public abstract float getYRenderScale();

    public abstract float getZRenderScale();

    public abstract MovingWorldAssemblyInteractor getAssemblyInteractor();

    public abstract void setAssemblyInteractor(MovingWorldAssemblyInteractor var1);
}

