/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.entity;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import java.util.HashSet;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MovingWorldHandlerCommon {
    public MovingWorldHandlerCommon(EntityMovingWorld entityMovingWorld) {
        this.setMovingWorld(entityMovingWorld);
    }

    public abstract EntityMovingWorld getMovingWorld();

    public abstract void setMovingWorld(EntityMovingWorld var1);

    public boolean processInitialInteract(EntityPlayer player, EnumHand hand) {
        return !player.func_70093_af();
    }

    public void onChunkUpdate() {
        BlockPos pos;
        MobileChunk chunk = this.getMovingWorld().getMobileChunk();
        this.getMovingWorld().getCapabilities().clearBlockCount();
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    pos = new BlockPos(i, j, k);
                    IBlockState blockState = chunk.func_180495_p(pos);
                    if (blockState == null || blockState.func_185904_a() == Material.field_151579_a) continue;
                    this.getMovingWorld().getCapabilities().onChunkBlockAdded(blockState, pos);
                }
            }
        }
        this.getMovingWorld().func_70105_a(Math.max(chunk.maxX() - chunk.minX(), chunk.maxZ() - chunk.minZ()), chunk.maxY() - chunk.minY());
        World.MAX_ENTITY_RADIUS = Math.max(World.MAX_ENTITY_RADIUS, (double)(Math.max(this.getMovingWorld().field_70130_N, this.getMovingWorld().field_70131_O) + 2.0f));
        try {
            this.getMovingWorld().fillAirBlocks(new HashSet<BlockPos>(), new BlockPos(-1, -1, -1));
        }
        catch (StackOverflowError e) {
            MovingWorldMod.LOG.error("Failure during moving world post-initialization", (Throwable)e);
        }
        this.getMovingWorld().setLayeredBlockVolumeCount(new int[chunk.maxY() - chunk.minY()]);
        for (int y = 0; y < this.getMovingWorld().getLayeredBlockVolumeCount().length; ++y) {
            for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
                for (int j = chunk.minZ(); j < chunk.maxZ(); ++j) {
                    pos = new BlockPos(i, y + chunk.minY(), j);
                    if (!chunk.isBlockTakingWaterVolume(pos)) continue;
                    int[] layeredBlockVolCount = this.getMovingWorld().getLayeredBlockVolumeCount();
                    int n = y;
                    layeredBlockVolCount[n] = layeredBlockVolCount[n] + 1;
                    this.getMovingWorld().setLayeredBlockVolumeCount(layeredBlockVolCount);
                }
            }
        }
        this.getMovingWorld().setFlying(this.getMovingWorld().getCapabilities().canFly());
        this.getMovingWorld().getCapabilities().postBlockAdding();
    }
}

