/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.mrot;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.mrot.BlockMetaRotation;
import com.elytradev.movingworld.common.mrot.OutdatedMrotException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import org.apache.commons.io.IOUtils;

public class MetaRotations {
    public Map<Integer, BlockMetaRotation> metaRotationMap = new HashMap<Integer, BlockMetaRotation>();
    private File metaRotationsDirectory;

    public boolean hasBlock(Block block) {
        return this.metaRotationMap.containsKey(Block.func_149682_b((Block)block));
    }

    public int getRotatedMeta(Block block, int meta, int rotate) {
        if (rotate == 0) {
            return meta;
        }
        BlockMetaRotation rotation = this.metaRotationMap.get(Block.func_149682_b((Block)block));
        if (rotation == null) {
            return meta;
        }
        return rotation.getRotatedMeta(meta, rotate);
    }

    public void addMetaRotation(Block block, int bitmask, int ... metarotation) {
        if (block == null) {
            MovingWorldMod.LOG.error("Adding null block meta rotations");
            return;
        }
        MovingWorldMod.LOG.trace("Adding meta rotations (block=" + Block.field_149771_c.func_177774_c((Object)block) + ", id=" + Block.func_149682_b((Block)block) + ", mask=" + bitmask + ", rot=" + Arrays.toString(metarotation) + ")");
        this.metaRotationMap.put(Block.func_149682_b((Block)block), new BlockMetaRotation(block, metarotation, bitmask));
    }

    public void setConfigDirectory(File configDirectory) {
        this.metaRotationsDirectory = new File(new File(configDirectory, "MovingWorld"), "MetaRotation");
        if (!this.metaRotationsDirectory.isDirectory()) {
            this.metaRotationsDirectory.mkdirs();
        }
    }

    public void registerMetaRotationFile(String fileName, InputStream iStream) throws IOException {
        File rotFile = new File(this.metaRotationsDirectory, fileName);
        if (!rotFile.exists()) {
            rotFile.createNewFile();
            FileOutputStream oStream = new FileOutputStream(rotFile);
            IOUtils.copy((InputStream)iStream, (OutputStream)oStream);
            iStream.close();
            oStream.close();
            MovingWorldMod.LOG.debug("Created " + fileName + " meta rotation");
        }
        MovingWorldMod.LOG.debug(fileName + " ready to load");
    }

    public boolean parseMetaRotations(BufferedReader reader) throws IOException, OutdatedMrotException {
        String line;
        boolean hasversionno = false;
        int lineno = 0;
        while ((line = reader.readLine()) != null) {
            String[] as;
            ++lineno;
            if (line.startsWith("#") || line.length() == 0) continue;
            if (line.startsWith("version=")) {
                hasversionno = true;
                as = line.split("=");
                if (as.length != 2) {
                    this.mrotError("Version number is invalid", lineno);
                    throw new OutdatedMrotException("?");
                }
                String modversion = "NULL";
                String version = as[1].trim();
                if (version.equals(modversion)) continue;
                throw new OutdatedMrotException(version);
            }
            int mask = -1;
            int[] rot = new int[4];
            as = line.split(";");
            if (as.length < 3) {
                this.mrotError("Not enough parameters", lineno);
                continue;
            }
            String[] blocksstr = as[0].split(",");
            Block[] blocks = new Block[blocksstr.length];
            for (int i = 0; i < blocksstr.length; ++i) {
                String name = blocksstr[i].trim();
                blocks[i] = Block.func_149684_b((String)name);
                if (blocks[i] != null) continue;
                this.mrotError("No block exists for " + name, lineno);
            }
            try {
                mask = Integer.decode(as[1].trim());
                String[] srot = as[2].split(",");
                for (int i = 0; i < rot.length; ++i) {
                    rot[i] = Integer.parseInt(srot[i].trim());
                }
            }
            catch (NumberFormatException e) {
                this.mrotError(e.getLocalizedMessage(), lineno);
            }
            for (Block b : blocks) {
                this.addMetaRotation(b, mask, rot);
            }
        }
        return hasversionno;
    }

    public void mrotError(String msg, int lineno) {
        MovingWorldMod.LOG.warn("Error in metarotation file at line " + lineno + " (" + msg + ")");
    }

    public void readMetaRotationFiles() {
        List<File> discovered;
        if (this.metaRotationsDirectory == null) {
            throw new NullPointerException("Config folder has not been initialized");
        }
        this.metaRotationMap.clear();
        try {
            try {
                this.readMetaRotationFile(new File(this.metaRotationsDirectory, "vanilla.mrot"));
            }
            catch (OutdatedMrotException ome) {
                MovingWorldMod.LOG.info("Outdated vanilla.mrot detected: " + ome.getLocalizedMessage());
                this.createDefaultMrot();
                this.readMetaRotationFile(new File(this.metaRotationsDirectory, "vanilla.mrot"));
            }
            catch (FileNotFoundException fnfe) {
                MovingWorldMod.LOG.info("vanilla.mrot file not found: " + fnfe.getLocalizedMessage());
                this.createDefaultMrot();
                this.readMetaRotationFile(new File(this.metaRotationsDirectory, "vanilla.mrot"));
            }
            catch (Exception e0) {
                throw e0;
            }
        }
        catch (Exception e1) {
            MovingWorldMod.LOG.error("Could not load default meta rotations", (Throwable)e1);
        }
        File vanillaMRot = new File(this.getClass().getResource("/mrot/vanilla.mrot").getPath());
        File modMetaRotations = new File(vanillaMRot.getParent() + "\\mod");
        if (modMetaRotations != null && modMetaRotations.isDirectory() && modMetaRotations.listFiles() != null && !Arrays.asList(modMetaRotations.listFiles()).isEmpty() && (discovered = Arrays.asList(modMetaRotations.listFiles())) != null && !discovered.isEmpty()) {
            for (File file : discovered) {
                try {
                    this.registerMetaRotationFile(file.getName(), new FileInputStream(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        File[] files = this.metaRotationsDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return !name.equals("vanilla.mrot") && name.endsWith(".mrot");
            }
        });
        for (File f : files) {
            try {
                this.readMetaRotationFile(f);
            }
            catch (OutdatedMrotException ome) {
                ome.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void readMetaRotationFile(File file) throws IOException, OutdatedMrotException {
        MovingWorldMod.LOG.info("Reading metarotation file: " + file.getName());
        BufferedReader reader = new BufferedReader(new FileReader(file));
        boolean flag = this.parseMetaRotations(reader);
        if (!flag && file.getName().equals("vanilla.mrot")) {
            throw new OutdatedMrotException("pre-1.4.4");
        }
        reader.close();
    }

    public void createDefaultMrot() {
        MovingWorldMod.LOG.info("Creating vanilla.mrot");
        try {
            this.registerMetaRotationFile("vanilla.mrot", this.getClass().getResourceAsStream("/mrot/vanilla.mrot"));
        }
        catch (IOException e) {
            MovingWorldMod.LOG.error("UNABLE TO LOAD VANILLA.MROT");
        }
    }
}

