/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.auxiliary.debug;

import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelper {
    private static final String CONSOLE_DEBUG_PREFIX = TextFormatting.AQUA + "[DEBUG] " + TextFormatting.RESET;
    private static final String CONSOLE_TRACE_PREFIX = TextFormatting.GOLD + "[TRACE] " + TextFormatting.RESET;
    public Logger logger;
    private boolean devEnv = false;
    private boolean enableDebug = false;
    private Level debugLevel = Level.DEBUG;
    private boolean debugToConsole = false;

    public LogHelper(String modid) {
        this.logger = LogManager.getLogger((String)modid);
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            this.devEnv = true;
            if (this.logger.getName().equals("timecore")) {
                this.info(TextFormatting.GREEN + "Dev enviroment was detected. Additional dev messages are enabled.");
            }
        }
    }

    public void info(String msg) {
        this.info(msg, new Object[0]);
    }

    public void info(String msg, Object ... params) {
        this.logger.info(msg, params);
    }

    public void warn(String msg) {
        this.warn(msg, new Object[0]);
    }

    public void warn(String msg, Object ... params) {
        this.logger.warn(msg, params);
    }

    public void error(String msg) {
        this.error(msg, new Object[0]);
    }

    public void error(String msg, Object ... params) {
        this.logger.error(msg, params);
    }

    public void error(Throwable e) {
        this.error("", e);
    }

    public void error(String msg, Throwable e) {
        this.logger.error(msg, e);
    }

    public void fatal(String msg) {
        this.fatal(msg, new Object[0]);
    }

    public void fatal(String msg, Object ... params) {
        this.logger.fatal(msg, params);
    }

    public void debug(String msg) {
        this.debug(msg, new Object[0]);
    }

    public void debug(String msg, Object ... params) {
        if (this.enableDebug && (this.debugLevel == Level.DEBUG || this.debugLevel == Level.TRACE)) {
            if (this.debugToConsole) {
                this.logger.info(CONSOLE_DEBUG_PREFIX + msg, params);
            } else {
                this.logger.debug(msg, params);
            }
        }
    }

    public void trace(String msg) {
        this.trace(msg, new Object[0]);
    }

    public void trace(String msg, Object ... params) {
        if (this.enableDebug && this.debugLevel == Level.TRACE) {
            if (this.debugToConsole) {
                this.logger.info(CONSOLE_TRACE_PREFIX + msg, params);
            } else {
                this.logger.debug(msg, params);
            }
        }
    }

    public void printDevOnlyMessage(String msg) {
        if (!this.devEnv) {
            return;
        }
        this.warn(msg);
        this.warn("This message appears only in dev enviroment.");
    }

    public void setPrintDebugToConsole(boolean state) {
        this.debugToConsole = state;
    }

    public boolean isDebugToConsoleOn() {
        return this.debugToConsole;
    }

    public boolean isDebugEnabled() {
        return this.enableDebug;
    }

    public void setDebugEnabled(boolean state) {
        this.enableDebug = state;
    }

    public void setDebugLevel(Level debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isInDev() {
        return this.devEnv;
    }

    public static enum Level {
        DEBUG,
        TRACE;

    }
}

