/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.auxiliary.debug;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Profiler {
    private Map<String, List<Long>> profilingMap = new HashMap<String, List<Long>>();

    public String[] getIdentifiers() {
        String[] tValues = new String[this.profilingMap.size()];
        this.profilingMap.keySet().toArray(tValues);
        return tValues;
    }

    public void addTimeToList(String identifier, long totalTime) {
        try {
            if (totalTime == 0L) {
                return;
            }
            if (!this.profilingMap.containsKey(identifier)) {
                this.profilingMap.put(identifier, new LinkedList());
            }
            LinkedList list = (LinkedList)this.profilingMap.get(identifier);
            list.addLast(totalTime);
            while (list.size() > 50) {
                list.removeFirst();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getAverageTime(String identifier) {
        try {
            if (!this.profilingMap.containsKey(identifier)) {
                return -1L;
            }
            int sum = 0;
            List<Long> list = this.profilingMap.get(identifier);
            for (long time : list) {
                sum = (int)((long)sum + time);
            }
            return sum / Math.max(1, list.size());
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

