/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.auxiliary.observer;

import java.util.ArrayList;
import ru.timeconqueror.timecore.api.auxiliary.observer.IListener;
import ru.timeconqueror.timecore.api.auxiliary.observer.IObservable;

public class SimpleObservable<T>
implements IObservable<T> {
    private T value;
    private T prevValue;
    private ArrayList<IListener<T>> observers = new ArrayList();

    public SimpleObservable(T value) {
        this.value = value;
        this.prevValue = value;
    }

    @Override
    public void addListener(IListener<T> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeListener(IListener<T> observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyListeners() {
        for (IListener<T> observer : this.observers) {
            observer.update(this.prevValue, this.value);
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.prevValue = this.value;
        this.value = value;
        this.notifyListeners();
    }

    public String toString() {
        return this.value.toString();
    }
}

