/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.client.obj.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.timecore.api.client.obj.model.AbstractObjModel;
import ru.timeconqueror.timecore.client.obj.loader.ObjModel;
import ru.timeconqueror.timecore.client.obj.loader.part.ModelObject;
import ru.timeconqueror.timecore.client.obj.loader.part.Vertex;

public class ObjModelRenderer {
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean isHidden;
    public List<ObjModelRenderer> childModels = new ArrayList<ObjModelRenderer>();
    private ModelObject model;
    private AbstractObjModel parent;
    private boolean compiled;
    private int displayList;

    public ObjModelRenderer(ObjModel parent, ModelObject modelForRender) {
        this.model = modelForRender;
        this.parent = parent;
    }

    public String getName() {
        return this.model.name;
    }

    public void setRotationPoint(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.rotationPointX = rotationPointXIn;
        this.rotationPointY = rotationPointYIn;
        this.rotationPointZ = rotationPointZIn;
    }

    public void setRotationPoint(Vertex vertex) {
        this.rotationPointX = vertex.x;
        this.rotationPointY = vertex.y;
        this.rotationPointZ = vertex.z;
    }

    public void addChild(ObjModelRenderer child) {
        this.childModels.add(child);
        this.parent.addDuplication(child);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale) {
        if (!this.isHidden) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                GlStateManager.func_179148_o((int)this.displayList);
                if (this.childModels != null) {
                    for (ObjModelRenderer childModel : this.childModels) {
                        childModel.render(scale);
                    }
                }
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
                if (this.rotateAngleZ != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GlStateManager.func_179114_b((float)(-this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GlStateManager.func_179109_b((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
                GlStateManager.func_179148_o((int)this.displayList);
                if (this.childModels != null) {
                    for (ObjModelRenderer childModel : this.childModels) {
                        childModel.render(scale);
                    }
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWithRotation(float scale) {
        if (!this.isHidden) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            if (this.rotateAngleY != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.rotateAngleZ != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
            GlStateManager.func_179148_o((int)this.displayList);
            if (this.childModels != null) {
                for (ObjModelRenderer childModel : this.childModels) {
                    childModel.render(scale);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender(float scale) {
        if (!this.isHidden) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
                    GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
                }
            } else {
                GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
                if (this.rotateAngleZ != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        this.model.render(bufferbuilder, scale);
        GlStateManager.func_187415_K();
        this.compiled = true;
    }
}

