/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.registry;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EasyRegistry {
    private final String modid;
    private CreativeTabs tab;

    public EasyRegistry(String modid, @Nullable CreativeTabs tabIn) {
        this.modid = modid;
        this.tab = tabIn;
    }

    public EasyRegistry setTab(@Nullable CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public void registerBlock(Block block, String name) {
        this.registerBlock(block, name, name);
    }

    public void registerBlock(Block block, String unlocalizedName, String registryName) {
        ForgeRegistries.BLOCKS.register(block.func_149663_c(this.modid + "." + unlocalizedName).setRegistryName(this.modid, registryName));
    }

    public void registerBlockWithItem(Block block, String name, ItemBlock itemBlock) {
        this.registerBlockWithItem(block, name, name, itemBlock);
    }

    public void registerBlockWithItem(Block block, String unlocalizedName, String registryName, ItemBlock itemBlock) {
        if (this.tab != null) {
            block.func_149647_a(this.tab);
        }
        ForgeRegistries.BLOCKS.register(block.func_149663_c(this.modid + "." + unlocalizedName).setRegistryName(this.modid, registryName));
        ForgeRegistries.ITEMS.register(itemBlock.setRegistryName(this.modid, registryName));
    }

    public void registerItem(Item item, String name) {
        if (this.tab != null) {
            item.func_77637_a(this.tab);
        }
        ForgeRegistries.ITEMS.register(item.func_77655_b(this.modid + "." + name).setRegistryName(this.modid, name));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemRender(Item item, int meta, String fileName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.modid + ":" + fileName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name) {
        GameRegistry.registerTileEntity(tileEntityClass, (ResourceLocation)new ResourceLocation(this.modid, "te." + name));
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void registerTESR(Class<T> tileEntityClass, TileEntitySpecialRenderer<? super T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileEntityClass, renderer);
    }

    public SoundEvent registerSound(ResourceLocation rl) {
        SoundEvent soundevent = new SoundEvent(rl);
        soundevent.setRegistryName(rl);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)soundevent);
        return soundevent;
    }
}

