/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.IClientCommand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.timecore.client.obj.generator.ObjFileGenerator;
import ru.timeconqueror.timecore.reference.FileReferences;

public class CommandClientMain
extends CommandBase
implements IClientCommand {
    public boolean allowUsageWithoutPrefix(ICommandSender sender, String message) {
        return false;
    }

    public String func_71517_b() {
        return "timecore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.timecore.main.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args2) throws CommandException {
        if (args2.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args2[0].equals(Commands.GENERATE_OBJ.getName())) {
            this.generateObj(server, sender, args2);
        } else if (args2[0].equals(Commands.HELP.getName())) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.timecore.help.msg", new Object[0]));
            for (Commands value : Commands.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(value.getUsage(), new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void generateObj(MinecraftServer server, ICommandSender sender, String[] args2) throws CommandException {
        if (args2.length < 2) {
            throw new WrongUsageException("timecore.command." + (Object)((Object)Commands.GENERATE_OBJ) + ".usage", new Object[0]);
        }
        String entityName = args2[1];
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (args2.length >= 3) {
            String s1 = CommandClientMain.func_180529_a((String[])args2, (int)2);
            try {
                tagCompound = JsonToNBT.func_180713_a((String)s1);
            }
            catch (NBTException nbtexception) {
                throw new CommandException("commands.summon.tagError", new Object[]{nbtexception.getMessage()});
            }
        }
        tagCompound.func_74778_a("id", entityName);
        Entity entity = this.createEntityFromNBT(tagCompound, (World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            throw new CommandException("timecore.command." + (Object)((Object)Commands.GENERATE_OBJ) + ".unknown", new Object[0]);
        }
        Render renderSimple = Minecraft.func_71410_x().func_175598_ae().func_78715_a(entity.getClass());
        if (!(renderSimple instanceof RenderLivingBase)) {
            entity.func_70106_y();
            throw new CommandException("timecore.command." + (Object)((Object)Commands.GENERATE_OBJ) + ".not_living", new Object[0]);
        }
        RenderLivingBase renderLiving = (RenderLivingBase)renderSimple;
        ModelBase model = renderLiving.func_177087_b();
        entity.func_70106_y();
        new ObjFileGenerator().create(FileReferences.TIMECORE_GENOBJ_DIR, model, entity.func_70005_c_());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args2, @Nullable BlockPos targetPos) {
        if (args2.length == 1) {
            return CommandClientMain.func_71530_a((String[])args2, (String[])Commands.getCommands());
        }
        if (args2[0].equals(Commands.GENERATE_OBJ.getName()) && args2.length == 2) {
            return CommandClientMain.func_175762_a((String[])args2, (Collection)EntityList.func_180124_b());
        }
        return Collections.emptyList();
    }

    @Nullable
    private Entity createEntityFromNBT(NBTTagCompound compound, World worldIn) {
        try {
            return EntityList.func_75615_a((NBTTagCompound)compound, (World)worldIn);
        }
        catch (RuntimeException var3) {
            return null;
        }
    }

    private static enum Commands {
        GENERATE_OBJ("genobj"),
        HELP("help");

        private String name;
        private String usage;

        private Commands(String name) {
            this.name = name;
            this.usage = "command.timecore." + name + ".usage";
        }

        public static String[] getCommands() {
            String[] commands = new String[Commands.values().length];
            for (int i = 0; i < Commands.values().length; ++i) {
                commands[i] = Commands.values()[i].name;
            }
            return commands;
        }

        public String getUsage() {
            return this.usage;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

