/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.obj.generator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class ObjFileGenerator {
    private File outputFile;
    private ModelBase model;
    private int currentCubeIndex = 1;
    private int textureWidth;
    private int textureHeight;
    private List<String> verticesGeometric = new ArrayList<String>();
    private List<String> verticesTexture = new ArrayList<String>();
    private List<String> verticesNormal = new ArrayList<String>();
    private int lastIndexVerGeometric = 0;
    private int lastIndexVerTexture = 0;
    private int lastIndexVerNormal = 0;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private float oldOffSetX;
    private float oldOffSetY;
    private float oldOffSetZ;
    private float rotatedX;
    private float rotatedY;
    private float rotatedZ;
    private float rotationAngleDegreeX;
    private float rotationAngleDegreeY;
    private float rotationAngleDegreeZ;
    private List<String> currentGroupFaces = new ArrayList<String>();

    public void create(String targetFolder, ModelBase modelIn, String entityName) {
        if (!this.createFile(targetFolder, entityName, "obj")) {
            return;
        }
        this.model = modelIn;
        this.textureWidth = this.model.field_78090_t;
        this.textureHeight = this.model.field_78089_u;
        try {
            this.processModelRendererList(this.model.field_78092_r);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("timecore.genobj.successgen", new Object[0]));
    }

    private void processModelRendererList(List<ModelRenderer> renderers) throws IOException {
        if (renderers == null) {
            return;
        }
        for (ModelRenderer renderer : renderers) {
            this.processModelRenderer(renderer);
        }
    }

    private void processModelRenderer(ModelRenderer renderer) throws IOException {
        if (!renderer.field_78806_j || renderer.field_78807_k) {
            return;
        }
        this.offsetX += renderer.field_78800_c;
        this.offsetY += renderer.field_78797_d;
        this.offsetZ += renderer.field_78798_e;
        this.rotationAngleDegreeX = renderer.field_78795_f * 57.295776f;
        this.rotationAngleDegreeY = renderer.field_78796_g * 57.295776f;
        this.rotationAngleDegreeZ = renderer.field_78808_h * 57.295776f;
        this.createNewGroup(renderer);
        if (renderer.field_78804_l != null) {
            for (ModelBox modelBox : renderer.field_78804_l) {
                for (TexturedQuad texturedQuad : modelBox.field_78254_i) {
                    this.processTexturedQuad(texturedQuad);
                }
            }
        }
        this.printGroupDataToFile();
        this.verticesGeometric.clear();
        this.verticesTexture.clear();
        this.verticesNormal.clear();
        this.currentGroupFaces.clear();
        this.processModelRendererList(renderer.field_78805_m);
        this.offsetX -= renderer.field_78800_c;
        this.offsetY -= renderer.field_78797_d;
        this.offsetZ -= renderer.field_78798_e;
    }

    private void translateOffsetsByAngles(ModelRenderer renderer) {
        this.oldOffSetX += renderer.field_78800_c;
        this.oldOffSetY += renderer.field_78797_d;
        this.oldOffSetZ += renderer.field_78798_e;
        if (this.rotationAngleDegreeX != 0.0f) {
            this.offsetY = (float)((double)this.offsetY * Math.cos(this.rotationAngleDegreeX) + (double)this.offsetZ * Math.sin(this.rotationAngleDegreeX));
            this.offsetZ = (float)((double)this.offsetY * -Math.sin(this.rotationAngleDegreeX) + (double)this.offsetZ * Math.cos(this.rotationAngleDegreeX));
        }
        if (this.rotationAngleDegreeY != 0.0f) {
            this.offsetX = (float)((double)this.offsetX * Math.cos(this.rotationAngleDegreeY) + (double)this.offsetZ * Math.sin(this.rotationAngleDegreeY));
            this.offsetZ = (float)((double)this.offsetX * -Math.sin(this.rotationAngleDegreeY) + (double)this.offsetZ * Math.cos(this.rotationAngleDegreeY));
        }
        if (this.rotationAngleDegreeZ != 0.0f) {
            this.offsetX = (float)((double)this.offsetX * Math.cos(this.rotationAngleDegreeZ) + (double)this.offsetY * -Math.sin(this.rotationAngleDegreeZ));
            this.offsetY = (float)((double)this.offsetX * Math.sin(this.rotationAngleDegreeZ) + (double)this.offsetY * Math.cos(this.rotationAngleDegreeZ));
        }
    }

    private void translateByAngles(float x, float y, float z) {
        this.rotatedX = x;
        this.rotatedY = y;
        this.rotatedZ = z;
    }

    private void printGroupDataToFile() throws IOException {
        FileUtils.writeLines((File)this.outputFile, this.verticesGeometric, (boolean)true);
        FileUtils.writeLines((File)this.outputFile, this.verticesTexture, (boolean)true);
        FileUtils.writeLines((File)this.outputFile, this.verticesNormal, (boolean)true);
        FileUtils.writeLines((File)this.outputFile, this.currentGroupFaces, (boolean)true);
    }

    private void processTexturedQuad(TexturedQuad quad) {
        Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
        Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
        Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        float vecNormalX = (float)vec3d2.field_72450_a;
        float vecNormalY = (float)vec3d2.field_72448_b;
        float vecNormalZ = (float)vec3d2.field_72449_c;
        int firstIndexGeom = this.lastIndexVerGeometric + 1;
        int firstIndexTexture = this.lastIndexVerTexture + 1;
        int indexNormal = this.lastIndexVerNormal + 1;
        for (int i = 0; i < 4; ++i) {
            PositionTextureVertex vertex = quad.field_78239_a[i];
            this.translateByAngles((float)vertex.field_78243_a.field_72450_a, (float)vertex.field_78243_a.field_72448_b, (float)vertex.field_78243_a.field_72449_c);
            String vertexGeom = "v " + (this.offsetX + this.rotatedX) + " " + -1.0f * (this.offsetY + this.rotatedY) + " " + (this.offsetZ + this.rotatedZ);
            this.verticesGeometric.add(vertexGeom);
            ++this.lastIndexVerGeometric;
            String vertexTexture = "vt " + vertex.field_78241_b + " " + vertex.field_78242_c;
            this.verticesTexture.add(vertexTexture);
            ++this.lastIndexVerTexture;
        }
        String vertexNormal = "vn " + vecNormalX + " " + vecNormalY + " " + vecNormalZ;
        this.verticesNormal.add(vertexNormal);
        ++this.lastIndexVerNormal;
        String face = "f " + firstIndexGeom++ + "/" + firstIndexTexture++ + "/" + indexNormal + " " + firstIndexGeom++ + "/" + firstIndexTexture++ + "/" + indexNormal + " " + firstIndexGeom++ + "/" + firstIndexTexture++ + "/" + indexNormal + " " + firstIndexGeom + "/" + firstIndexTexture + "/" + indexNormal;
        this.currentGroupFaces.add(face);
    }

    private void createNewGroup(ModelRenderer renderer) throws IOException {
        String groupName = renderer.field_78802_n == null || renderer.field_78802_n.equals("null") ? "Cube." + this.currentCubeIndex++ : renderer.field_78802_n;
        FileUtils.write((File)this.outputFile, (CharSequence)("g " + groupName + "\n"), (Charset)Charsets.UTF_8, (boolean)true);
    }

    private boolean createFile(String folder, String fileName, String extension) {
        boolean created;
        File objFolder = new File(folder);
        if (!objFolder.exists() && !objFolder.mkdirs()) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("timecore.genobj.cantcreatefolder", new Object[0]));
            return false;
        }
        File file = new File(folder + "/" + fileName + "." + extension);
        if (!file.exists()) {
            try {
                created = file.createNewFile();
            }
            catch (IOException e) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("timecore.genobj.cantcreatefile", new Object[0]));
                e.printStackTrace();
                return false;
            }
        }
        FileUtils.deleteQuietly((File)file);
        try {
            created = file.createNewFile();
        }
        catch (IOException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("timecore.genobj.cantcreatefile", new Object[0]));
            e.printStackTrace();
            return false;
        }
        if (!created) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Can't create output file. Obj file won't be created. Check logs for details.");
            return false;
        }
        this.outputFile = file;
        return true;
    }
}

