/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.obj.loader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import ru.timeconqueror.timecore.TimeCore;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelRenderer;
import ru.timeconqueror.timecore.client.obj.loader.ModelFormatException;
import ru.timeconqueror.timecore.client.obj.loader.ObjModel;
import ru.timeconqueror.timecore.client.obj.loader.part.Face;
import ru.timeconqueror.timecore.client.obj.loader.part.ModelObject;
import ru.timeconqueror.timecore.client.obj.loader.part.TextureCoordinate;
import ru.timeconqueror.timecore.client.obj.loader.part.Vertex;

public class ObjModelBuilder {
    private static Pattern vertexPattern = Pattern.compile("(v( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *\\n)|(v( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *$)");
    private static Pattern vertexNormalPattern = Pattern.compile("(vn( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *\\n)|(vn( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *$)");
    private static Pattern textureCoordinatePattern = Pattern.compile("(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *\\n)|(vt( (\\-){0,1}\\d+(\\.\\d+)?){2,3} *$)");
    private static Pattern face_V_VT_VN_Pattern = Pattern.compile("(f( \\d+/\\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+/\\d+){3,4} *$)");
    private static Pattern face_V_VT_Pattern = Pattern.compile("(f( \\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+){3,4} *$)");
    private static Pattern face_V_VN_Pattern = Pattern.compile("(f( \\d+//\\d+){3,4} *\\n)|(f( \\d+//\\d+){3,4} *$)");
    private static Pattern face_V_Pattern = Pattern.compile("(f( \\d+){3,4} *\\n)|(f( \\d+){3,4} *$)");
    private static Pattern groupObjectPattern = Pattern.compile("([go]( [\\w\\d\\.]+) *\\n)|([go]( [\\w\\d\\.]+) *$)");
    private static Matcher vertexMatcher;
    private static Matcher vertexNormalMatcher;
    private static Matcher textureCoordinateMatcher;
    private static Matcher face_V_VT_VN_Matcher;
    private static Matcher face_V_VT_Matcher;
    private static Matcher face_V_VN_Matcher;
    private static Matcher face_V_Matcher;
    private static Matcher groupObjectMatcher;
    public ArrayList<Vertex> vertices = new ArrayList();
    private ArrayList<Vertex> vertexNormals = new ArrayList();
    private ArrayList<TextureCoordinate> textureCoordinates = new ArrayList();
    private ModelObject currentModelObject;
    private ResourceLocation fileLocation;
    private ResourceLocation rpFileLocation;
    private ArrayList<ObjModelRenderer> renderers = new ArrayList();
    private ArrayList<RPVertex> rpVertexes = new ArrayList();

    public ObjModelBuilder(ResourceLocation rl) throws ModelFormatException {
        this.fileLocation = rl;
    }

    private static boolean isValidVertexLine(String line) {
        if (vertexMatcher != null) {
            vertexMatcher.reset();
        }
        vertexMatcher = vertexPattern.matcher(line);
        return vertexMatcher.matches();
    }

    private static boolean isValidVertexNormalLine(String line) {
        if (vertexNormalMatcher != null) {
            vertexNormalMatcher.reset();
        }
        vertexNormalMatcher = vertexNormalPattern.matcher(line);
        return vertexNormalMatcher.matches();
    }

    private static boolean isValidTextureCoordinateLine(String line) {
        if (textureCoordinateMatcher != null) {
            textureCoordinateMatcher.reset();
        }
        textureCoordinateMatcher = textureCoordinatePattern.matcher(line);
        return textureCoordinateMatcher.matches();
    }

    private static boolean isValidFace_V_VT_VN_Line(String line) {
        if (face_V_VT_VN_Matcher != null) {
            face_V_VT_VN_Matcher.reset();
        }
        face_V_VT_VN_Matcher = face_V_VT_VN_Pattern.matcher(line);
        return face_V_VT_VN_Matcher.matches();
    }

    private static boolean isValidFace_V_VT_Line(String line) {
        if (face_V_VT_Matcher != null) {
            face_V_VT_Matcher.reset();
        }
        face_V_VT_Matcher = face_V_VT_Pattern.matcher(line);
        return face_V_VT_Matcher.matches();
    }

    private static boolean isValidFace_V_VN_Line(String line) {
        if (face_V_VN_Matcher != null) {
            face_V_VN_Matcher.reset();
        }
        face_V_VN_Matcher = face_V_VN_Pattern.matcher(line);
        return face_V_VN_Matcher.matches();
    }

    private static boolean isValidFace_V_Line(String line) {
        if (face_V_Matcher != null) {
            face_V_Matcher.reset();
        }
        face_V_Matcher = face_V_Pattern.matcher(line);
        return face_V_Matcher.matches();
    }

    private static boolean isValidFaceLine(String line) {
        return ObjModelBuilder.isValidFace_V_VT_VN_Line(line) || ObjModelBuilder.isValidFace_V_VT_Line(line) || ObjModelBuilder.isValidFace_V_VN_Line(line) || ObjModelBuilder.isValidFace_V_Line(line);
    }

    private static boolean isValidGroupObjectLine(String line) {
        if (groupObjectMatcher != null) {
            groupObjectMatcher.reset();
        }
        groupObjectMatcher = groupObjectPattern.matcher(line);
        return groupObjectMatcher.matches();
    }

    public ObjModel loadModel() throws ModelFormatException {
        int lineCount = 0;
        ObjModel model = new ObjModel();
        try (IResource objFile = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.fileLocation);
             BufferedReader reader = new BufferedReader(new InputStreamReader(objFile.func_110527_b()));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                Vertex vertex;
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                if (currentLine.startsWith("v ")) {
                    vertex = this.parseVertex(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertices.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vn ")) {
                    vertex = this.parseVertexNormal(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertexNormals.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vt ")) {
                    TextureCoordinate textureCoordinate = this.parseTextureCoordinate(currentLine, lineCount);
                    if (textureCoordinate == null) continue;
                    this.textureCoordinates.add(textureCoordinate);
                    continue;
                }
                if (currentLine.startsWith("f ")) {
                    Face face;
                    if (this.currentModelObject == null) {
                        this.currentModelObject = new ModelObject("Default");
                    }
                    if ((face = this.parseFace(currentLine, lineCount)) == null) continue;
                    this.currentModelObject.faces.add(face);
                    continue;
                }
                if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                ModelObject group = this.parseGroupObject(currentLine, lineCount);
                if (group != null && this.currentModelObject != null) {
                    this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
                }
                this.currentModelObject = group;
            }
            this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", e);
        }
        String[] path = this.fileLocation.func_110623_a().split("/");
        String fileName = path[path.length - 1].split("\\.")[0];
        StringBuilder newPath = new StringBuilder();
        for (int i = 0; i < path.length - 1; ++i) {
            if (i != 0) {
                newPath.append("/");
            }
            newPath.append(path[i]);
        }
        this.rpFileLocation = new ResourceLocation(this.fileLocation.func_110624_b(), newPath + "/" + fileName + ".rp");
        this.loadRPFile();
        model.setParts(this.renderers);
        return model;
    }

    private void loadRPFile() {
        String type2 = null;
        int lineCount = 0;
        try (IResource objFile = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.rpFileLocation);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(objFile.func_110527_b()));
            Object object = null;
            try {
                String currentLine;
                while ((currentLine = reader.readLine()) != null) {
                    ++lineCount;
                    if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).isEmpty() || currentLine.startsWith("#")) continue;
                    if (currentLine.startsWith("!type") && lineCount == 1) {
                        type2 = currentLine.trim().split(" ")[1];
                        continue;
                    }
                    this.parseRPVertex(currentLine, lineCount);
                }
            }
            catch (Throwable currentLine) {
                object = currentLine;
                throw currentLine;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable currentLine) {
                            ((Throwable)object).addSuppressed(currentLine);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            if (TimeCore.logHelper.isInDev()) {
                String[] path = this.rpFileLocation.func_110623_a().split("/");
                TimeCore.logHelper.printDevOnlyMessage("No .rp file with the name " + path[path.length - 1] + " was found! All rotation points will be set to 0 by default.");
            }
            return;
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", e);
        }
        if (type2 != null && !type2.isEmpty()) {
            if (type2.equals("blender")) {
                for (RPVertex rpVertex : this.rpVertexes) {
                    float y = rpVertex.vertex.y;
                    rpVertex.vertex.y = rpVertex.vertex.z;
                    rpVertex.vertex.z = -y;
                }
            } else {
                TimeCore.logHelper.warn("Unknown type {} in .rp File with path {}", type2, this.rpFileLocation);
            }
        }
        for (ObjModelRenderer renderer : this.renderers) {
            boolean found = false;
            for (RPVertex rpVertex : this.rpVertexes) {
                if (!renderer.getName().equals(rpVertex.rendererName)) continue;
                renderer.setRotationPoint(rpVertex.vertex);
                found = true;
                break;
            }
            if (found) continue;
            TimeCore.logHelper.printDevOnlyMessage("No rotation point vertex was found for renderer with name " + renderer.getName() + " in rp-file. They will be set to 0 by default.");
        }
    }

    private void parseRPVertex(String line, int lineCount) throws ModelFormatException {
        RPVertex vertex;
        String[] splittedByEqualSign = line.split("=");
        if (splittedByEqualSign.length != 2) {
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.rpFileLocation + "' - \nThe line must contain key and vertexData in such case: name_of_object=x/y/z");
        }
        String name = splittedByEqualSign[0];
        String vertexData = splittedByEqualSign[1];
        String[] vertexCoords = vertexData.split("/");
        if (vertexCoords.length != 3) {
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.rpFileLocation + "' - Count of vertex coordinates must be equal 3.");
        }
        try {
            vertex = new RPVertex(name, new Vertex(Float.parseFloat(vertexCoords[0]), Float.parseFloat(vertexCoords[1]), Float.parseFloat(vertexCoords[2])));
        }
        catch (NumberFormatException e) {
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - \n" + String.format("Number formatting error at line %d", lineCount), e);
        }
        this.rpVertexes.add(vertex);
    }

    private Vertex parseVertex(String line, int lineCount) throws ModelFormatException {
        block5: {
            if (ObjModelBuilder.isValidVertexLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 2) {
                        return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                    }
                    if (tokens.length == 3) {
                        return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    private Vertex parseVertexNormal(String line, int lineCount) throws ModelFormatException {
        block4: {
            if (ObjModelBuilder.isValidVertexNormalLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 3) {
                        return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block4;
                }
                catch (NumberFormatException e) {
                    throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    private TextureCoordinate parseTextureCoordinate(String line, int lineCount) throws ModelFormatException {
        block5: {
            if (ObjModelBuilder.isValidTextureCoordinateLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 2) {
                        return new TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]));
                    }
                    if (tokens.length == 3) {
                        return new TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Face parseFace(String line, int lineCount) throws ModelFormatException {
        if (!ObjModelBuilder.isValidFaceLine(line)) throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        Face face = new Face();
        String trimmedLine = line.substring(line.indexOf(" ") + 1);
        String[] tokens = trimmedLine.split(" ");
        if (tokens.length == 3) {
            if (this.currentModelObject.glDrawingMode == -1) {
                this.currentModelObject.glDrawingMode = 4;
            } else if (this.currentModelObject.glDrawingMode != 4) {
                throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Invalid number of points for face (expected 4, found " + tokens.length + ")");
            }
        } else if (tokens.length == 4) {
            if (this.currentModelObject.glDrawingMode == -1) {
                this.currentModelObject.glDrawingMode = 7;
            } else if (this.currentModelObject.glDrawingMode != 7) {
                throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Invalid number of points for face (expected 3, found " + tokens.length + ")");
            }
        }
        if (ObjModelBuilder.isValidFace_V_VT_VN_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.textureCoordinates = new TextureCoordinate[tokens.length];
            face.vertexNormals = new Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[2]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (ObjModelBuilder.isValidFace_V_VT_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.textureCoordinates = new TextureCoordinate[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (ObjModelBuilder.isValidFace_V_VN_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.vertexNormals = new Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("//");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[1]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else {
            if (!ObjModelBuilder.isValidFace_V_Line(line)) throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
            face.vertices = new Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                face.vertices[i] = this.vertices.get(Integer.parseInt(tokens[i]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
        }
        return face;
    }

    private ModelObject parseGroupObject(String line, int lineCount) throws ModelFormatException {
        ModelObject group = null;
        if (ObjModelBuilder.isValidGroupObjectLine(line)) {
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            if (trimmedLine.length() > 0) {
                group = new ModelObject(trimmedLine);
            }
        } else {
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return group;
    }

    private class RPVertex {
        Vertex vertex;
        String rendererName;

        public RPVertex(String rendererName, Vertex vertex) {
            this.vertex = vertex;
            this.rendererName = rendererName;
        }

        public String toString() {
            return this.rendererName + ": " + this.vertex.toString();
        }
    }
}

