/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.obj.loader.model;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelBase;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelRenderer;
import ru.timeconqueror.timecore.client.obj.loader.ObjModel;

public class ObjModelQuadruped
extends ObjModelBase {
    public ObjModelRenderer head;
    public ObjModelRenderer body;
    public ObjModelRenderer leg1;
    public ObjModelRenderer leg2;
    public ObjModelRenderer leg3;
    public ObjModelRenderer leg4;
    protected float childYOffset = 8.0f;
    protected float childZOffset = 4.0f;

    public ObjModelQuadruped(ObjModel modelIn, String head, String body, String leg1, String leg2, String leg3, String leg4) {
        super(modelIn);
        this.initParts(head, body, leg1, leg2, leg3, leg4);
    }

    public void initParts(String head, String body, String leg1, String leg2, String leg3, String leg4) {
        for (ObjModelRenderer renderer : this.model.getParts()) {
            if (renderer.getName().equals(head)) {
                this.head = renderer;
                continue;
            }
            if (renderer.getName().equals(body)) {
                this.body = renderer;
                continue;
            }
            if (renderer.getName().equals(leg1)) {
                this.leg1 = renderer;
                continue;
            }
            if (renderer.getName().equals(leg2)) {
                this.leg2 = renderer;
                continue;
            }
            if (renderer.getName().equals(leg3)) {
                this.leg3 = renderer;
                continue;
            }
            if (!renderer.getName().equals(leg4)) continue;
            this.leg4 = renderer;
        }
    }

    @Override
    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        if (this.field_78091_s) {
            float f = 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(this.childYOffset * scale), (float)(this.childZOffset * scale));
            this.head.render(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.body.render(scale);
            this.leg1.render(scale);
            this.leg2.render(scale);
            this.leg3.render(scale);
            this.leg4.render(scale);
            GlStateManager.func_179121_F();
        } else {
            this.head.render(scale);
            this.body.render(scale);
            this.leg1.render(scale);
            this.leg2.render(scale);
            this.leg3.render(scale);
            this.leg4.render(scale);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        this.head.rotateAngleX = headPitch * ((float)Math.PI / 180);
        this.head.rotateAngleY = netHeadYaw * ((float)Math.PI / 180);
        this.body.rotateAngleX = 1.5707964f;
        this.leg1.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }
}

