/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui.commands;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.gui.GuiSlider;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.network.packets.gui.PregenTaskPacket;
import pregenerator.impl.storage.PregenTask;

public class GuiExpansionPregen
extends GuiPregenBase {
    GuiScreen prev;
    SelectionList<String> shapes = new SelectionList<String>(Arrays.asList("Square", "Circle"));
    SelectionList<Integer> dimensions = new SelectionList();
    SelectionList<String> genTypes = new SelectionList<String>(Arrays.asList("Terrain Only", "Terrain & Post", "Post Only", "Block Post", "Retrogen"));

    public GuiExpansionPregen(GuiScreen prev) {
        this.prev = prev;
        this.dimensions.addValues(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        this.dimensions.setIndexFromValue(0);
        this.genTypes.next();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerButton(0, -40, 90, 80, 20, "Back");
        this.registerButton(1, -70, -60, 160, 20, "Generation Shape: " + this.shapes.getValue());
        this.registerButton(new GuiSlider(2, this.centerX - 160, this.centerY - 30, 160, 20, "Min Radius: ", " Chunks", 1.0, 4000.0, 100.0, false, true).setScrollEffect(1.0));
        this.registerButton(new GuiSlider(3, this.centerX + 10, this.centerY - 30, 160, 20, "Max Radius: ", " Chunks", 1.0, 4000.0, 100.0, false, true).setScrollEffect(1.0));
        this.registerButton(new GuiSlider(4, this.centerX - 160, this.centerY, 160, 20, "Gen Center X: ", " Chunk", -100.0, 100.0, 0.0, false, true).setScrollEffect(1.0));
        this.registerButton(new GuiSlider(5, this.centerX + 10, this.centerY, 160, 20, "Gen Center Z: ", " Chunk", -100.0, 100.0, 0.0, false, true).setScrollEffect(1.0));
        this.registerButton(6, -160, 30, 160, 20, "Dimension: " + this.getName());
        this.registerButton(7, 10, 30, 160, 20, "GenType: " + this.genTypes.getValue());
        this.registerButton(8, -40, 60, 80, 20, "Pregen!");
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.func_147108_a(this.prev);
        } else if (id == 1) {
            if (GuiScreen.func_146272_n()) {
                this.shapes.prev();
            } else {
                this.shapes.next();
            }
            button.field_146126_j = "Generation Shape: " + this.shapes.getValue();
        } else if (id == 6) {
            if (GuiScreen.func_146272_n()) {
                this.dimensions.prev();
            } else {
                this.dimensions.next();
            }
            button.field_146126_j = "Dimension: " + this.getName();
        } else if (id == 7) {
            if (GuiScreen.func_146272_n()) {
                this.genTypes.prev();
            } else {
                this.genTypes.next();
            }
            button.field_146126_j = "GenType: " + this.genTypes.getValue();
        } else if (id == 7) {
            ChunkPregenerator.networking.sendPacketToServer(new PregenTaskPacket(this.createTask()));
            this.field_146297_k.func_147108_a(this.prev);
        }
    }

    public PregenTask createTask() {
        int centerX = ((GuiSlider)this.getIDButton(4)).getValueInt();
        int centerZ = ((GuiSlider)this.getIDButton(5)).getValueInt();
        int minRadius = ((GuiSlider)this.getIDButton(2)).getValueInt();
        int maxRadius = ((GuiSlider)this.getIDButton(3)).getValueInt();
        return new PregenTask(4 + this.shapes.getIndex(), (int)this.dimensions.getValue(), centerX, this.centerY, minRadius, maxRadius, this.genTypes.getIndex());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCenterText("Pregen Expansion", 0, -100, Color.WHITE.getRGB());
        this.drawCenterText("This Mode can not Exeed 4 Million Chunks of Pregeneration", 0, -80, Color.WHITE.getRGB());
        this.handleTooltip(mouseX, mouseY);
    }

    public void handleTooltip(int mouseX, int mouseY) {
        int min = ((GuiSlider)this.getIDButton(2)).getValueInt() * 16;
        int max = ((GuiSlider)this.getIDButton(3)).getValueInt() * 16;
        if (this.getIDButton(1).func_146115_a()) {
            this.drawListText(Arrays.asList("The Shape that the World be Pregenerated in"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(2).func_146115_a()) {
            this.drawListText(Arrays.asList("The Minimum Radius that the Pregenrator starts at", "This can not Exceed or Equal the Maximum Radius", "Minimum Size: " + min + " x " + min + " Blocks", "Expected Amount of Chunks to Generate: " + this.getTotalGenerationCount()), mouseX, mouseY + 30);
        }
        if (this.getIDButton(3).func_146115_a()) {
            this.drawListText(Arrays.asList("The Maximum Radius that the Pregenerator will stop At", "This can not be smaller or Equal to the Minimum Radius", "Maximum Size: " + max + " x " + max + " Blocks", "Expected Amount of Chunks to Generate: " + this.getTotalGenerationCount()), mouseX, mouseY + 30);
        } else if (this.getIDButton(4).func_146115_a() || this.getIDButton(5).func_146115_a()) {
            int x = ((GuiSlider)this.getIDButton(4)).getValueInt() * 16;
            int z = ((GuiSlider)this.getIDButton(5)).getValueInt() * 16;
            this.drawListText(Arrays.asList("Defines where the Center of the Pregeneration is", "Center: X=" + x + ", Z=" + z), mouseX, mouseY - 15);
        } else if (this.getIDButton(6).func_146115_a()) {
            this.drawListText(Arrays.asList("Defines in which dimension the Generation happens"), mouseX, mouseY - 15);
        } else if (this.getIDButton(7).func_146115_a()) {
            this.drawListText(Arrays.asList("Defines which Type of Generation it is"), mouseX, mouseY - 15);
        }
        this.getIDButton((int)8).field_146124_l = this.getTotalGenerationCount() <= 4000000 && min < max;
    }

    private int getTotalGenerationCount() {
        return BasePregenCommand.getRingCount(((GuiSlider)this.getIDButton(2)).getValueInt(), ((GuiSlider)this.getIDButton(3)).getValueInt(), this.shapes.getIndex() == 1);
    }

    public String getName() {
        int dim = this.dimensions.getValue();
        return dim + " (" + GuiExpansionPregen.getDimensionName(dim) + ")";
    }

    public static String getDimensionName(int id) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String s : DimensionManager.getProviderType((int)id).func_186065_b().replace("_", " ").split(" ")) {
                builder.append(StringUtils.capitalize((String)s)).append(" ");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

