/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui.commands;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.gui.GuiSlider;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.network.packets.gui.PregenTaskPacket;
import pregenerator.impl.storage.PregenTask;

public class GuiSimplePregen
extends GuiPregenBase {
    GuiScreen prev;
    SelectionList<String> shapes = new SelectionList<String>(Arrays.asList("Square", "Circle"));
    SelectionList<Integer> dimensions = new SelectionList();
    SelectionList<String> genTypes = new SelectionList<String>(Arrays.asList("Terrain Only", "Terrain & Post", "Post Only", "Block Post", "Retrogen"));

    public GuiSimplePregen(GuiScreen prev) {
        this.prev = prev;
        this.dimensions.addValues(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        this.dimensions.setIndexFromValue(0);
        this.genTypes.next();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerButton(0, -40, 90, 80, 20, "Back");
        this.registerButton(1, -160, -60, 160, 20, "Generation Shape: " + this.shapes.getValue());
        this.registerButton(new GuiSlider(2, this.centerX + 10, this.centerY - 60, 160, 20, "Radius: ", " Chunks", 1.0, 1000.0, 100.0, false, true).setScrollEffect(1.0));
        this.registerButton(new GuiSlider(3, this.centerX - 160, this.centerY - 30, 160, 20, "Gen Center X: ", " Chunk", -100.0, 100.0, 0.0, false, true).setScrollEffect(1.0));
        this.registerButton(new GuiSlider(4, this.centerX + 10, this.centerY - 30, 160, 20, "Gen Center Z: ", " Chunk", -100.0, 100.0, 0.0, false, true).setScrollEffect(1.0));
        this.registerButton(5, -160, 0, 160, 20, "Dimension: " + this.getName());
        this.registerButton(6, 10, 0, 160, 20, "GenType: " + this.genTypes.getValue());
        this.registerButton(7, -40, 30, 80, 20, "Pregen!");
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.func_147108_a(this.prev);
        } else if (id == 1) {
            if (GuiScreen.func_146272_n()) {
                this.shapes.prev();
            } else {
                this.shapes.next();
            }
            button.field_146126_j = "Generation Shape: " + this.shapes.getValue();
        } else if (id == 5) {
            if (GuiScreen.func_146272_n()) {
                this.dimensions.prev();
            } else {
                this.dimensions.next();
            }
            button.field_146126_j = "Dimension: " + this.getName();
        } else if (id == 6) {
            if (GuiScreen.func_146272_n()) {
                this.genTypes.prev();
            } else {
                this.genTypes.next();
            }
            button.field_146126_j = "GenType: " + this.genTypes.getValue();
        } else if (id == 7) {
            ChunkPregenerator.networking.sendPacketToServer(new PregenTaskPacket(this.createTask()));
            this.field_146297_k.func_147108_a(this.prev);
        }
    }

    public PregenTask createTask() {
        int centerX = ((GuiSlider)this.getIDButton(3)).getValueInt();
        int centerZ = ((GuiSlider)this.getIDButton(4)).getValueInt();
        int radius = ((GuiSlider)this.getIDButton(2)).getValueInt();
        return new PregenTask(this.shapes.getIndex(), (int)this.dimensions.getValue(), centerX, this.centerY, radius, 0, this.genTypes.getIndex());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCenterText("Simple Pregen", 0, -100, Color.WHITE.getRGB());
        this.handleTooltip(mouseX, mouseY);
    }

    public void handleTooltip(int mouseX, int mouseY) {
        if (this.getIDButton(1).func_146115_a()) {
            this.drawListText(Arrays.asList("The Shape that the World be Pregenerated in"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(2).func_146115_a()) {
            int size = ((GuiSlider)this.getIDButton(2)).getValueInt() * 32;
            this.drawListText(Arrays.asList("Expected World Size: " + size + "x" + size + " Blocks"), mouseX, mouseY - 15);
        } else if (this.getIDButton(3).func_146115_a() || this.getIDButton(4).func_146115_a()) {
            int x = ((GuiSlider)this.getIDButton(3)).getValueInt() * 16;
            int z = ((GuiSlider)this.getIDButton(4)).getValueInt() * 16;
            this.drawListText(Arrays.asList("Defines where the Center of the Pregeneration is", "Center: X=" + x + ", Z=" + z), mouseX, mouseY - 15);
        } else if (this.getIDButton(5).func_146115_a()) {
            this.drawListText(Arrays.asList("Defines in which dimension the Generation happens"), mouseX, mouseY - 15);
        } else if (this.getIDButton(6).func_146115_a()) {
            this.drawListText(Arrays.asList("Defines which Type of Generation it is"), mouseX, mouseY - 15);
        }
    }

    public String getName() {
        int dim = this.dimensions.getValue();
        return dim + " (" + GuiSimplePregen.getDimensionName(dim) + ")";
    }

    public static String getDimensionName(int id) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String s : DimensionManager.getProviderType((int)id).func_186065_b().replace("_", " ").split(" ")) {
                builder.append(StringUtils.capitalize((String)s)).append(" ");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

