/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.gui.GuiChunkInfo;
import pregenerator.impl.client.gui.GuiStructureView;
import pregenerator.impl.client.gui.GuiTrackerOptions;
import pregenerator.impl.client.gui.GuiWorldView;
import pregenerator.impl.tracking.WorldTracker;

public class DimAnswerPacket
extends PregenPacket {
    Set<Integer> set = new HashSet<Integer>();
    int target;

    public DimAnswerPacket() {
    }

    public DimAnswerPacket(List<WorldTracker> list, int answer) {
        for (WorldTracker tracker : list) {
            this.set.add(tracker.getDimID());
        }
        this.target = answer;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.target = buffer.readByte();
        int expected = buffer.readShort();
        for (int i = 0; i < expected; ++i) {
            this.set.add(buffer.readInt());
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeByte(this.target);
        buffer.writeShort(this.set.size());
        for (Integer entry : this.set) {
            buffer.writeInt(entry);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        if (this.target == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof GuiTrackerOptions) {
                ((GuiTrackerOptions)mc.field_71462_r).addDimensions(new ArrayList<Integer>(this.set));
            }
        } else if (this.target == 1) {
            GuiChunkInfo.INSTANCE.addDims(new ArrayList<Integer>(this.set));
        } else if (this.target == 2) {
            GuiWorldView.ENTITIES.addDims(new ArrayList<Integer>(this.set));
        } else if (this.target == 3) {
            GuiWorldView.TILE_ENTITIES.addDims(new ArrayList<Integer>(this.set));
        } else if (this.target == 4) {
            GuiStructureView.INSTANCE.addDims(new ArrayList<Integer>(this.set));
        }
    }
}

