/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.Chunk;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.network.packets.chunkRequest.ChunkAnswerPacket;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;

public class ChunkRequest
extends PregenPacket {
    int currentDim;

    public ChunkRequest(int dim) {
        this.currentDim = dim;
    }

    public ChunkRequest() {
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.currentDim = buffer.readInt();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.currentDim);
    }

    @Override
    public void handle(final EntityPlayer player) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (!server.func_152345_ab()) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ChunkRequest.this.process(player);
                }
            });
            return;
        }
        this.process(player);
    }

    public void process(EntityPlayer player) {
        int i;
        WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.currentDim);
        if (tracker == null) {
            ChunkAnswerPacket answer = new ChunkAnswerPacket();
            answer.setType(-1);
            ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
            return;
        }
        List<Chunk> chunks = tracker.getChunks();
        if (chunks.isEmpty()) {
            ChunkAnswerPacket answer = new ChunkAnswerPacket();
            answer.setType(-1);
            ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
            return;
        }
        ArrayList<ChunkAnswerPacket> toSend = new ArrayList<ChunkAnswerPacket>();
        ChunkAnswerPacket current = new ChunkAnswerPacket();
        int bytesLeft = 30000;
        for (i = 0; i < chunks.size(); ++i) {
            ChunkEntry entry = ChunkEntry.fromChunk(chunks.get(i));
            if (entry.getBytes() > bytesLeft) {
                toSend.add(current);
                current = new ChunkAnswerPacket();
                bytesLeft = 30000;
            }
            current.addChunkEntry(entry);
            bytesLeft -= entry.getBytes();
        }
        if (current.hasData()) {
            toSend.add(current);
        }
        for (i = 0; i < toSend.size(); ++i) {
            ChunkAnswerPacket packet = (ChunkAnswerPacket)toSend.get(i);
            packet.setType(toSend.size() - (i + 1));
            ChunkPregenerator.networking.sendPacketToPlayer(packet, player);
        }
    }
}

