/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiDetector;
import vswe.stevescarts.helpers.ModuleState;
import vswe.stevescarts.helpers.OperatorObject;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.packet.PacketStevesCarts;

public class LogicObject {
    private byte id;
    private LogicObject parent;
    private byte type;
    private ArrayList<LogicObject> childs;
    private int x;
    private int y;
    private int level;
    private byte data;

    public LogicObject(byte id, byte type, byte data) {
        this.id = id;
        this.type = type;
        this.data = data;
        this.childs = new ArrayList();
    }

    public LogicObject(byte type, byte data) {
        this(0, type, data);
    }

    public void setParent(TileEntityDetector detector, LogicObject parent) {
        if (parent != null) {
            PacketStevesCarts.sendPacket(0, new byte[]{parent.id, this.getExtra(), this.data});
            for (LogicObject child : this.childs) {
                child.setParent(detector, this);
            }
        } else {
            PacketStevesCarts.sendPacket(1, new byte[]{this.id});
        }
    }

    public void setParent(LogicObject parent) {
        if (this.parent != null) {
            this.parent.childs.remove(this);
        }
        this.parent = parent;
        if (this.parent != null && this.parent.hasRoomForChild()) {
            this.parent.childs.add(this);
        }
    }

    public ArrayList<LogicObject> getChilds() {
        return this.childs;
    }

    public LogicObject getParent() {
        return this.parent;
    }

    public byte getId() {
        return this.id;
    }

    public byte getExtra() {
        return this.type;
    }

    public byte getData() {
        return this.data;
    }

    public void setX(int val) {
        this.x = val;
    }

    public void setY(int val) {
        this.y = val;
    }

    public void setXCenter(int val) {
        this.setX(val + (this.isOperator() ? -10 : -8));
    }

    public void setYCenter(int val) {
        this.setY(val + (this.isOperator() ? -5 : -8));
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiDetector gui, int mouseX, int mouseY, int x, int y) {
        this.generatePosition(x - 50, y, 100, 0);
        this.draw(gui, mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiDetector gui, int mouseX, int mouseY) {
        if (!this.isOperator()) {
            ResourceHelper.bindResource(GuiDetector.texture);
            int yIndex = 0;
            if (gui.inRect(mouseX, mouseY, this.getRect())) {
                yIndex = 1;
            }
            gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 0, 202 + yIndex * 16, 16, 16);
            if (this.isModule()) {
                ModuleData module = ModuleData.getList().get(this.data);
                if (module != null) {
                    gui.drawModuleIcon(module, gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 1.0f, 1.0f, 0.0f, 0.0f);
                }
            } else {
                ResourceHelper.bindResource(GuiDetector.stateTexture);
                int[] src = gui.getModuleTexture(this.data);
                gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, src[0], src[1], 16, 16);
            }
        } else {
            ResourceHelper.bindResource(GuiDetector.texture);
            int[] src2 = gui.getOperatorTexture(this.data);
            gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, src2[0], src2[1], 20, 11);
            if (gui.inRect(mouseX, mouseY, this.getRect())) {
                int yIndex2 = gui.currentObject == null ? 2 : (this.hasRoomForChild() && this.isChildValid(gui.currentObject) ? 0 : 1);
                gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 16, 202 + yIndex2 * 11, 20, 11);
            }
        }
        if (this.parent != null && this.parent.maxChilds() > 1) {
            int px1 = gui.getGuiLeft() + this.x;
            int py1 = gui.getGuiTop() + this.y;
            int px2 = gui.getGuiLeft() + this.parent.x;
            int py2 = gui.getGuiTop() + this.parent.y;
            py2 += 5;
            px1 += this.isOperator() ? 10 : 8;
            boolean tooClose = false;
            if (this.x > this.parent.x) {
                if (px1 < (px2 += 20)) {
                    tooClose = true;
                }
            } else if (px1 > px2) {
                tooClose = true;
            }
            if (!tooClose) {
                Gui.func_73734_a((int)px1, (int)py2, (int)px2, (int)(py2 + 1), (int)-12566464);
                Gui.func_73734_a((int)px1, (int)py1, (int)(px1 + 1), (int)py2, (int)-12566464);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        for (LogicObject child : this.childs) {
            child.draw(gui, mouseX, mouseY);
        }
    }

    public void generatePosition(int x, int y, int w, int level) {
        this.setXCenter(x + w / 2);
        this.setYCenter(y);
        this.level = level;
        int max = this.maxChilds();
        for (int i = 0; i < this.childs.size(); ++i) {
            this.childs.get(i).generatePosition(x + w / max * i, y + (this.childs.get(i).isOperator() ? 11 : 16), w / max, level + (this.childs.get(i).maxChilds() > 1 ? 1 : 0));
        }
    }

    private boolean isModule() {
        return this.type == 0;
    }

    private boolean isOperator() {
        return this.type == 1;
    }

    private boolean isState() {
        return this.type == 2;
    }

    private OperatorObject getOperator() {
        if (this.isOperator()) {
            return OperatorObject.getAllOperators().get(this.data);
        }
        return null;
    }

    public boolean evaluateLogicTree(TileEntityDetector detector, EntityMinecartModular cart, int depth) {
        if (depth >= 1000) {
            return false;
        }
        if (this.isState()) {
            ModuleState state = ModuleState.getStates().get(this.getData());
            return state != null && state.evaluate(cart);
        }
        if (this.isModule()) {
            for (ModuleBase module : cart.getModules()) {
                if (this.getData() != module.getModuleId()) continue;
                return true;
            }
            return false;
        }
        if (this.getChilds().size() != this.maxChilds()) {
            return false;
        }
        OperatorObject operator = this.getOperator();
        if (operator == null) {
            return false;
        }
        if (operator.getChildCount() == 2) {
            return operator.evaluate(detector, cart, depth + 1, this.getChilds().get(0), this.getChilds().get(1));
        }
        if (operator.getChildCount() == 1) {
            return operator.evaluate(detector, cart, depth + 1, this.getChilds().get(0), null);
        }
        return operator.evaluate(detector, cart, depth + 1, null, null);
    }

    private int maxChilds() {
        OperatorObject operator = this.getOperator();
        if (operator != null) {
            return operator.getChildCount();
        }
        return 0;
    }

    public boolean isChildValid(LogicObject child) {
        if (this.level >= 4 && child.isOperator()) {
            return false;
        }
        if (this.level >= 5) {
            return false;
        }
        OperatorObject operator = this.getOperator();
        OperatorObject operatorchild = child.getOperator();
        return operator == null || operatorchild == null || operator.isChildValid(operatorchild);
    }

    public boolean canBeRemoved() {
        OperatorObject operator = this.getOperator();
        return operator == null || operator.inTab();
    }

    public boolean hasRoomForChild() {
        return this.childs.size() < this.maxChilds();
    }

    public int[] getRect() {
        if (!this.isOperator()) {
            return new int[]{this.x, this.y, 16, 16};
        }
        return new int[]{this.x, this.y, 20, 11};
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogicObject) {
            LogicObject logic = (LogicObject)obj;
            return logic.id == this.id && (logic.parent == null && this.parent == null || logic.parent != null && this.parent != null && logic.parent.id == this.parent.id) && logic.getExtra() == this.getExtra() && logic.getData() == this.getData();
        }
        return false;
    }

    public LogicObject copy(LogicObject parent) {
        LogicObject obj = new LogicObject(this.id, this.getExtra(), this.getData());
        obj.setParent(parent);
        return obj;
    }

    public String getName() {
        if (this.isState()) {
            ModuleState state = ModuleState.getStates().get(this.getData());
            if (state == null) {
                return "Undefined";
            }
            return state.getName();
        }
        if (!this.isModule()) {
            String name = "Undefined";
            OperatorObject operator = this.getOperator();
            if (operator != null) {
                name = operator.getName();
            }
            return name + "\nChild nodes: " + this.getChilds().size() + "/" + this.maxChilds();
        }
        ModuleData module = ModuleData.getList().get(this.getData());
        if (module == null) {
            return "Undefined";
        }
        return module.getName();
    }
}

