/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.block.BlockRailBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleRocket
extends ModuleBase {
    private boolean flying;
    private int landDirX;
    private int landDirZ;
    private double flyX;
    private double flyZ;
    private float yaw;
    private boolean isLanding;
    private double landY;
    private double groundY;
    private DataParameter<Integer> UNKNOWN;

    public ModuleRocket(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.isPlaceholder()) {
            return;
        }
        if (this.getCart().field_70170_p.field_72995_K) {
            if (!this.flying && this.getDw(this.UNKNOWN) != 0) {
                this.takeOff();
            } else if (!this.isLanding && this.getDw(this.UNKNOWN) > 1) {
                this.land();
            } else if (this.flying && this.isLanding && this.getDw(this.UNKNOWN) == 0) {
                this.done();
            }
        }
        if (this.flying) {
            this.getCart().field_70159_w = this.isLanding ? (double)((float)this.landDirX * 0.05f) : 0.0;
            this.getCart().field_70181_x = this.isLanding ? 0.0 : 0.1;
            double d = this.getCart().field_70179_y = this.isLanding ? (double)((float)this.landDirZ * 0.05f) : 0.0;
            if (!this.isLanding || this.landDirX == 0) {
                this.getCart().field_70165_t = this.flyX;
            } else {
                EntityMinecartModular cart = this.getCart();
                cart.field_70165_t += this.getCart().field_70159_w;
            }
            if (!this.isLanding || this.landDirZ == 0) {
                this.getCart().field_70161_v = this.flyZ;
            } else {
                EntityMinecartModular cart2 = this.getCart();
                cart2.field_70161_v += this.getCart().field_70179_y;
            }
            this.getCart().field_70177_z = this.yaw;
            this.getCart().field_70125_A = 0.0f;
            BlockPos pos = this.getCart().func_180425_c();
            if (this.isLanding) {
                this.getCart().field_70163_u = this.landY;
                if (BlockRailBase.func_176562_d((World)this.getCart().field_70170_p, (BlockPos)pos)) {
                    this.done();
                    this.updateDw(this.UNKNOWN, 0);
                }
            }
            if (!this.isLanding && this.getCart().field_70163_u - this.groundY > 2.0 && BlockRailBase.func_176562_d((World)this.getCart().field_70170_p, (BlockPos)pos.func_177982_a(this.landDirX, 0, this.landDirZ))) {
                this.land();
                this.updateDw(this.UNKNOWN, 2);
            }
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active) {
            this.takeOff();
            this.updateDw(this.UNKNOWN, 1);
        }
    }

    private void takeOff() {
        this.flying = true;
        this.getCart().setCanUseRail(false);
        this.flyX = this.getCart().field_70165_t;
        this.flyZ = this.getCart().field_70161_v;
        this.yaw = this.getCart().field_70177_z;
        this.groundY = this.getCart().field_70163_u;
        if (Math.abs(this.getCart().field_70159_w) > Math.abs(this.getCart().field_70179_y)) {
            this.landDirX = this.getCart().field_70159_w > 0.0 ? 1 : -1;
        } else {
            this.landDirZ = this.getCart().field_70179_y > 0.0 ? 1 : -1;
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.UNKNOWN = this.createDw(DataSerializers.field_187192_b);
        this.registerDw(this.UNKNOWN, 0);
    }

    private void land() {
        this.isLanding = true;
        this.landY = this.getCart().field_70163_u;
        this.getCart().setCanUseRail(true);
    }

    private void done() {
        this.flying = false;
        this.isLanding = false;
        this.landDirX = 0;
        this.landDirZ = 0;
    }
}

