/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.packet;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;

public class PacketFluidSync
implements INetworkPacket<PacketFluidSync> {
    private FluidStack fluidStack;
    private BlockPos pos;
    private int worldID;
    private int tankID;

    public PacketFluidSync(FluidStack fluidStack, BlockPos pos, int worldID, int tankID) {
        this.fluidStack = fluidStack;
        this.pos = pos;
        this.worldID = worldID;
        this.tankID = tankID;
    }

    public PacketFluidSync() {
    }

    public void writeData(ExtendedPacketBuffer buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        this.fluidStack.writeToNBT(compound);
        buffer.func_150786_a(compound);
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.worldID);
        buffer.writeInt(this.tankID);
    }

    public void readData(ExtendedPacketBuffer buffer) throws IOException {
        this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
        this.pos = buffer.func_179259_c();
        this.worldID = buffer.readInt();
        this.tankID = buffer.readInt();
    }

    public void processData(PacketFluidSync message, MessageContext context) {
        if (context.side == Side.CLIENT) {
            if (!FMLClientHandler.instance().getClient().func_152345_ab()) {
                FMLClientHandler.instance().getClient().func_152344_a(() -> this.processData(message, context));
            } else {
                TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                if (tile instanceof TileEntityLiquid) {
                    ((TileEntityLiquid)tile).tanks[message.tankID].setFluid(message.fluidStack);
                } else if (tile instanceof TileEntityUpgrade) {
                    ((TileEntityUpgrade)tile).tank.setFluid(message.fluidStack);
                }
            }
        }
    }
}

