/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import com.github.javaparser.ast.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;

public class AccessFlags {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MANDATED = 32768;
    public final int access;

    public AccessFlags(int access) {
        this.access = access;
    }

    public AccessFlags(EnumSet<Modifier> modifiers) {
        this(AccessFlags.accessFor(modifiers));
    }

    private static int accessFor(EnumSet<Modifier> modifiers) {
        int access = 0;
        if (modifiers.contains(Modifier.PUBLIC)) {
            access |= 1;
        }
        if (modifiers.contains(Modifier.PRIVATE)) {
            access |= 2;
        }
        if (modifiers.contains(Modifier.PROTECTED)) {
            access |= 4;
        }
        if (modifiers.contains(Modifier.STATIC)) {
            access |= 8;
        }
        if (modifiers.contains(Modifier.FINAL)) {
            access |= 0x10;
        }
        if (modifiers.contains(Modifier.SYNCHRONIZED)) {
            access |= 0x20;
        }
        if (modifiers.contains(Modifier.VOLATILE)) {
            access |= 0x40;
        }
        if (modifiers.contains(Modifier.TRANSIENT)) {
            access |= 0x80;
        }
        if (modifiers.contains(Modifier.NATIVE)) {
            access |= 0x100;
        }
        if (modifiers.contains(Modifier.ABSTRACT)) {
            access |= 0x400;
        }
        if (modifiers.contains(Modifier.STRICTFP)) {
            access |= 0x800;
        }
        return access;
    }

    public EnumSet<Modifier> toJavaParserModifierSet() {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (this.has(1)) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (this.has(2)) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (this.has(4)) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (this.has(8)) {
            modifiers.add(Modifier.STATIC);
        }
        if (this.has(16)) {
            modifiers.add(Modifier.FINAL);
        }
        if (this.has(32)) {
            modifiers.add(Modifier.SYNCHRONIZED);
        }
        if (this.has(64)) {
            modifiers.add(Modifier.VOLATILE);
        }
        if (this.has(128)) {
            modifiers.add(Modifier.TRANSIENT);
        }
        if (this.has(256)) {
            modifiers.add(Modifier.NATIVE);
        }
        if (this.has(1024)) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (this.has(2048)) {
            modifiers.add(Modifier.STRICTFP);
        }
        return EnumSet.copyOf(modifiers);
    }

    public String toString() {
        return "Access: " + this.access + " (" + JVMUtil.accessIntToString(this.access) + ")";
    }

    public boolean equals(Object o) {
        return o == this || o instanceof AccessFlags && ((AccessFlags)o).access == this.access;
    }

    public int hashCode() {
        return this.access;
    }

    public boolean has(int flag) {
        return (this.access & flag) == flag;
    }

    public AccessFlags makeAccessible(boolean needsPublic) {
        return new AccessFlags(JVMUtil.makeAccess(this.access, needsPublic));
    }

    public AccessFlags with(int flag) {
        return new AccessFlags(this.access | flag);
    }

    public AccessFlags without(int flag) {
        return new AccessFlags(this.access & ~flag);
    }
}

